package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample;
/**
 * 关系型数据实体[IBIZSample] 查询条件对象
 */
@Slf4j
@Data
public class IBIZSampleSearchContext extends QueryWrapperContext<IBIZSample> {

	private String n_ibizsamplename_like;//[示例数据库名称]
	public void setN_ibizsamplename_like(String n_ibizsamplename_like) {
        this.n_ibizsamplename_like = n_ibizsamplename_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsamplename_like)){
            this.getSearchCond().like("ibizsamplename", n_ibizsamplename_like);
        }
    }
	private String n_ibizsampleid_like;//[示例数据库标识]
	public void setN_ibizsampleid_like(String n_ibizsampleid_like) {
        this.n_ibizsampleid_like = n_ibizsampleid_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsampleid_like)){
            this.getSearchCond().like("ibizsampleid", n_ibizsampleid_like);
        }
    }
	private String n_sampletype_eq;//[示例类型]
	public void setN_sampletype_eq(String n_sampletype_eq) {
        this.n_sampletype_eq = n_sampletype_eq;
        if(!ObjectUtils.isEmpty(this.n_sampletype_eq)){
            this.getSearchCond().eq("sampletype", n_sampletype_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsamplename", query)
            );
		 }
	}
}



