package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0005;
/**
 * 关系型数据实体[IBIZSample0005] 查询条件对象
 */
@Slf4j
@Data
public class IBIZSample0005SearchContext extends QueryWrapperContext<IBIZSample0005> {

	private String n_wfmmstep_eq;//[工作流步骤]
	public void setN_wfmmstep_eq(String n_wfmmstep_eq) {
        this.n_wfmmstep_eq = n_wfmmstep_eq;
        if(!ObjectUtils.isEmpty(this.n_wfmmstep_eq)){
            this.getSearchCond().eq("wfmmstep", n_wfmmstep_eq);
        }
    }
	private String n_wfmmtype_eq;//[订单类型]
	public void setN_wfmmtype_eq(String n_wfmmtype_eq) {
        this.n_wfmmtype_eq = n_wfmmtype_eq;
        if(!ObjectUtils.isEmpty(this.n_wfmmtype_eq)){
            this.getSearchCond().eq("wfmmtype", n_wfmmtype_eq);
        }
    }
	private String n_ibizsample0005name_like;//[多模式流程名称]
	public void setN_ibizsample0005name_like(String n_ibizsample0005name_like) {
        this.n_ibizsample0005name_like = n_ibizsample0005name_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0005name_like)){
            this.getSearchCond().like("ibizsample0005name", n_ibizsample0005name_like);
        }
    }
	private String n_wfmmstate_eq;//[状态]
	public void setN_wfmmstate_eq(String n_wfmmstate_eq) {
        this.n_wfmmstate_eq = n_wfmmstate_eq;
        if(!ObjectUtils.isEmpty(this.n_wfmmstate_eq)){
            this.getSearchCond().eq("wfmmstate", n_wfmmstate_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0005name", query)
            );
		 }
	}
}



