package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0004;
/**
 * 关系型数据实体[IBIZSample0004] 查询条件对象
 */
@Slf4j
@Data
public class IBIZSample0004SearchContext extends QueryWrapperContext<IBIZSample0004> {

	private String n_wfmvstate_eq;//[状态]
	public void setN_wfmvstate_eq(String n_wfmvstate_eq) {
        this.n_wfmvstate_eq = n_wfmvstate_eq;
        if(!ObjectUtils.isEmpty(this.n_wfmvstate_eq)){
            this.getSearchCond().eq("wfmvstate", n_wfmvstate_eq);
        }
    }
	private String n_wfmvtype_eq;//[订单类型]
	public void setN_wfmvtype_eq(String n_wfmvtype_eq) {
        this.n_wfmvtype_eq = n_wfmvtype_eq;
        if(!ObjectUtils.isEmpty(this.n_wfmvtype_eq)){
            this.getSearchCond().eq("wfmvtype", n_wfmvtype_eq);
        }
    }
	private String n_wfmvstep_eq;//[工作流步骤]
	public void setN_wfmvstep_eq(String n_wfmvstep_eq) {
        this.n_wfmvstep_eq = n_wfmvstep_eq;
        if(!ObjectUtils.isEmpty(this.n_wfmvstep_eq)){
            this.getSearchCond().eq("wfmvstep", n_wfmvstep_eq);
        }
    }
	private String n_ibizsample0004name_like;//[名称]
	public void setN_ibizsample0004name_like(String n_ibizsample0004name_like) {
        this.n_ibizsample0004name_like = n_ibizsample0004name_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0004name_like)){
            this.getSearchCond().like("ibizsample0004name", n_ibizsample0004name_like);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0004name", query)
            );
		 }
	}
}



