package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0002;
/**
 * 关系型数据实体[IBIZSample0002] 查询条件对象
 */
@Slf4j
@Data
public class IBIZSample0002SearchContext extends QueryWrapperContext<IBIZSample0002> {

	private String n_ibizsample0002name_like;//[首页图表数据源名称]
	public void setN_ibizsample0002name_like(String n_ibizsample0002name_like) {
        this.n_ibizsample0002name_like = n_ibizsample0002name_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0002name_like)){
            this.getSearchCond().like("ibizsample0002name", n_ibizsample0002name_like);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0002name", query)
            );
		 }
	}
}



