package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZOrder;
/**
 * 关系型数据实体[IBIZOrder] 查询条件对象
 */
@Slf4j
@Data
public class IBIZOrderSearchContext extends QueryWrapperContext<IBIZOrder> {

	private String n_ordertype_eq;//[订单类型]
	public void setN_ordertype_eq(String n_ordertype_eq) {
        this.n_ordertype_eq = n_ordertype_eq;
        if(!ObjectUtils.isEmpty(this.n_ordertype_eq)){
            this.getSearchCond().eq("ordertype", n_ordertype_eq);
        }
    }
	private String n_orderstate_eq;//[订单状态]
	public void setN_orderstate_eq(String n_orderstate_eq) {
        this.n_orderstate_eq = n_orderstate_eq;
        if(!ObjectUtils.isEmpty(this.n_orderstate_eq)){
            this.getSearchCond().eq("orderstate", n_orderstate_eq);
        }
    }
	private String n_wfstep_eq;//[工作流步骤]
	public void setN_wfstep_eq(String n_wfstep_eq) {
        this.n_wfstep_eq = n_wfstep_eq;
        if(!ObjectUtils.isEmpty(this.n_wfstep_eq)){
            this.getSearchCond().eq("wfstep", n_wfstep_eq);
        }
    }
	private String n_ibizordername_like;//[订单名称]
	public void setN_ibizordername_like(String n_ibizordername_like) {
        this.n_ibizordername_like = n_ibizordername_like;
        if(!ObjectUtils.isEmpty(this.n_ibizordername_like)){
            this.getSearchCond().like("ibizordername", n_ibizordername_like);
        }
    }
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
	private Timestamp n_ordertime_gt;//[订单时间]
	public void setN_ordertime_gt(Timestamp n_ordertime_gt) {
        this.n_ordertime_gt = n_ordertime_gt;
        if(!ObjectUtils.isEmpty(this.n_ordertime_gt)){
            this.getSearchCond().gt("ordertime", n_ordertime_gt);
        }
    }
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
	private Timestamp n_ordertime_gtandeq;//[订单时间]
	public void setN_ordertime_gtandeq(Timestamp n_ordertime_gtandeq) {
        this.n_ordertime_gtandeq = n_ordertime_gtandeq;
        if(!ObjectUtils.isEmpty(this.n_ordertime_gtandeq)){
            this.getSearchCond().ge("ordertime", n_ordertime_gtandeq);
        }
    }
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
	private Timestamp n_ordertime_lt;//[订单时间]
	public void setN_ordertime_lt(Timestamp n_ordertime_lt) {
        this.n_ordertime_lt = n_ordertime_lt;
        if(!ObjectUtils.isEmpty(this.n_ordertime_lt)){
            this.getSearchCond().lt("ordertime", n_ordertime_lt);
        }
    }
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    @JSONField(format="yyyy-MM-dd")
	private Timestamp n_ordertime_ltandeq;//[订单时间]
	public void setN_ordertime_ltandeq(Timestamp n_ordertime_ltandeq) {
        this.n_ordertime_ltandeq = n_ordertime_ltandeq;
        if(!ObjectUtils.isEmpty(this.n_ordertime_ltandeq)){
            this.getSearchCond().le("ordertime", n_ordertime_ltandeq);
        }
    }
	private String n_ibizcustomername_eq;//[客户名称]
	public void setN_ibizcustomername_eq(String n_ibizcustomername_eq) {
        this.n_ibizcustomername_eq = n_ibizcustomername_eq;
        if(!ObjectUtils.isEmpty(this.n_ibizcustomername_eq)){
            this.getSearchCond().eq("ibizcustomername", n_ibizcustomername_eq);
        }
    }
	private String n_ibizcustomername_like;//[客户名称]
	public void setN_ibizcustomername_like(String n_ibizcustomername_like) {
        this.n_ibizcustomername_like = n_ibizcustomername_like;
        if(!ObjectUtils.isEmpty(this.n_ibizcustomername_like)){
            this.getSearchCond().like("ibizcustomername", n_ibizcustomername_like);
        }
    }
	private String n_ibizcustomerid_eq;//[客户标识]
	public void setN_ibizcustomerid_eq(String n_ibizcustomerid_eq) {
        this.n_ibizcustomerid_eq = n_ibizcustomerid_eq;
        if(!ObjectUtils.isEmpty(this.n_ibizcustomerid_eq)){
            this.getSearchCond().eq("ibizcustomerid", n_ibizcustomerid_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizordername", query)
            );
		 }
	}
}



