package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZHardware;
/**
 * 关系型数据实体[IBIZHardware] 查询条件对象
 */
@Slf4j
@Data
public class IBIZHardwareSearchContext extends QueryWrapperContext<IBIZHardware> {

	private String n_ibizhardwaretype_eq;//[分组类型]
	public void setN_ibizhardwaretype_eq(String n_ibizhardwaretype_eq) {
        this.n_ibizhardwaretype_eq = n_ibizhardwaretype_eq;
        if(!ObjectUtils.isEmpty(this.n_ibizhardwaretype_eq)){
            this.getSearchCond().eq("ibizhardwaretype", n_ibizhardwaretype_eq);
        }
    }
	private String n_ibizhardwarename_like;//[名称]
	public void setN_ibizhardwarename_like(String n_ibizhardwarename_like) {
        this.n_ibizhardwarename_like = n_ibizhardwarename_like;
        if(!ObjectUtils.isEmpty(this.n_ibizhardwarename_like)){
            this.getSearchCond().like("ibizhardwarename", n_ibizhardwarename_like);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizhardwarename", query)
            );
		 }
	}
}



