package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZBOOK;
/**
 * 关系型数据实体[IBIZBOOK] 查询条件对象
 */
@Slf4j
@Data
public class IBIZBOOKSearchContext extends QueryWrapperContext<IBIZBOOK> {

	private String n_ibizbookname_like;//[图书名称]
	public void setN_ibizbookname_like(String n_ibizbookname_like) {
        this.n_ibizbookname_like = n_ibizbookname_like;
        if(!ObjectUtils.isEmpty(this.n_ibizbookname_like)){
            this.getSearchCond().like("ibizbookname", n_ibizbookname_like);
        }
    }
	private Double n_price_gtandeq;//[图书价格]
	public void setN_price_gtandeq(Double n_price_gtandeq) {
        this.n_price_gtandeq = n_price_gtandeq;
        if(!ObjectUtils.isEmpty(this.n_price_gtandeq)){
            this.getSearchCond().ge("price", n_price_gtandeq);
        }
    }
	private String n_sailstate_eq;//[图书销售状态]
	public void setN_sailstate_eq(String n_sailstate_eq) {
        this.n_sailstate_eq = n_sailstate_eq;
        if(!ObjectUtils.isEmpty(this.n_sailstate_eq)){
            this.getSearchCond().eq("sailstate", n_sailstate_eq);
        }
    }
	private String n_borrowway_eq;//[借阅方式]
	public void setN_borrowway_eq(String n_borrowway_eq) {
        this.n_borrowway_eq = n_borrowway_eq;
        if(!ObjectUtils.isEmpty(this.n_borrowway_eq)){
            this.getSearchCond().eq("borrowway", n_borrowway_eq);
        }
    }
	private String n_returnlib_eq;//[归还图馆]
	public void setN_returnlib_eq(String n_returnlib_eq) {
        this.n_returnlib_eq = n_returnlib_eq;
        if(!ObjectUtils.isEmpty(this.n_returnlib_eq)){
            this.getSearchCond().eq("returnlib", n_returnlib_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizbookname", query)
            );
		 }
	}
}



