package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[供货商]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "t_supplier", resultMap = "IBIZSupplierResultMap")
public class IBIZSupplier extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 是否删除标记
     */
    @DEField(preType = DEPredefinedFieldType.LOGICVALID, logicval = "Y", logicdelval = "N")
    @TableLogic(value = "Y", delval = "N")
    @TableField(value = "deleteflag")
    @JSONField(name = "deleteflag")
    @JsonProperty("deleteflag")
    private String deleteflag;
    /**
     * 创建人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createby", fill = FieldFill.INSERT)
    @JSONField(name = "createby")
    @JsonProperty("createby")
    private String createby;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateby")
    @JSONField(name = "updateby")
    @JsonProperty("updateby")
    private String updateby;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatetime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatetime", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatetime")
    private Timestamp updatetime;
    /**
     * 邮箱
     */
    @TableField(value = "email")
    @JSONField(name = "email")
    @JsonProperty("email")
    private String email;
    /**
     * 供应商名称
     */
    @TableField(value = "suppliername")
    @JSONField(name = "suppliername")
    @JsonProperty("suppliername")
    private String suppliername;
    /**
     * 创建时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createtime", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createtime", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createtime")
    private Timestamp createtime;
    /**
     * 地址
     */
    @TableField(value = "address")
    @JSONField(name = "address")
    @JsonProperty("address")
    private String address;
    /**
     * 供应商标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "supplierid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "supplierid")
    @JsonProperty("supplierid")
    private String supplierid;



    /**
     * 设置 [邮箱]
     */
    public void setEmail(String email) {
        this.email = email;
        this.modify("email", email);
    }

    /**
     * 设置 [供应商名称]
     */
    public void setSuppliername(String suppliername) {
        this.suppliername = suppliername;
        this.modify("suppliername", suppliername);
    }

    /**
     * 设置 [地址]
     */
    public void setAddress(String address) {
        this.address = address;
        this.modify("address", address);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("supplierid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


