package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[员工]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0020", resultMap = "IBIZSample0020ResultMap")
public class IBIZSample0020 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 员工名称
     */
    @TableField(value = "ibizsample0020name")
    @JSONField(name = "ibizsample0020name")
    @JsonProperty("ibizsample0020name")
    private String ibizsample0020name;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 员工标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0020id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0020id")
    @JsonProperty("ibizsample0020id")
    private String ibizsample0020id;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 部门名称
     */
    @TableField(value = "ibizsample0019name")
    @JSONField(name = "ibizsample0019name")
    @JsonProperty("ibizsample0019name")
    private String ibizsample0019name;
    /**
     * 部门id
     */
    @TableField(value = "ibizsample0019id")
    @JSONField(name = "ibizsample0019id")
    @JsonProperty("ibizsample0019id")
    private String ibizsample0019id;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.sample.domain.IBIZSample0019 ibizsample0019;



    /**
     * 设置 [员工名称]
     */
    public void setIbizsample0020name(String ibizsample0020name) {
        this.ibizsample0020name = ibizsample0020name;
        this.modify("ibizsample0020name", ibizsample0020name);
    }

    /**
     * 设置 [部门名称]
     */
    public void setIbizsample0019name(String ibizsample0019name) {
        this.ibizsample0019name = ibizsample0019name;
        this.modify("ibizsample0019name", ibizsample0019name);
    }

    /**
     * 设置 [部门id]
     */
    public void setIbizsample0019id(String ibizsample0019id) {
        this.ibizsample0019id = ibizsample0019id;
        this.modify("ibizsample0019id", ibizsample0019id);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0020id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


