package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[多模式流程]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0005", resultMap = "IBIZSample0005ResultMap")
public class IBIZSample0005 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 订单金额
     */
    @TableField(value = "je")
    @JSONField(name = "je")
    @JsonProperty("je")
    private BigDecimal je;
    /**
     * 工作流实例
     */
    @TableField(value = "wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    private String wfinstanceid;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 订单时间
     */
    @TableField(value = "mmdate")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "mmdate", format = "yyyy-MM-dd")
    @JsonProperty("mmdate")
    private Timestamp mmdate;
    /**
     * 多模式流程标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0005id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0005id")
    @JsonProperty("ibizsample0005id")
    private String ibizsample0005id;
    /**
     * 工作流版本
     */
    @TableField(value = "wfversion")
    @JSONField(name = "wfversion")
    @JsonProperty("wfversion")
    private String wfversion;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 工作流步骤
     */
    @TableField(value = "wfmmstep")
    @JSONField(name = "wfmmstep")
    @JsonProperty("wfmmstep")
    private String wfmmstep;
    /**
     * 订单类型
     */
    @TableField(value = "wfmmtype")
    @JSONField(name = "wfmmtype")
    @JsonProperty("wfmmtype")
    private String wfmmtype;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 工作流步骤
     */
    @TableField(value = "wfstate")
    @JSONField(name = "wfstate")
    @JsonProperty("wfstate")
    private Integer wfstate;
    /**
     * 多模式流程名称
     */
    @TableField(value = "ibizsample0005name")
    @JSONField(name = "ibizsample0005name")
    @JsonProperty("ibizsample0005name")
    private String ibizsample0005name;
    /**
     * 备注
     */
    @TableField(value = "memo")
    @JSONField(name = "memo")
    @JsonProperty("memo")
    private String memo;
    /**
     * 状态
     */
    @TableField(value = "wfmmstate")
    @JSONField(name = "wfmmstate")
    @JsonProperty("wfmmstate")
    private String wfmmstate;



    /**
     * 设置 [订单金额]
     */
    public void setJe(BigDecimal je) {
        this.je = je;
        this.modify("je", je);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfinstanceid(String wfinstanceid) {
        this.wfinstanceid = wfinstanceid;
        this.modify("wfinstanceid", wfinstanceid);
    }

    /**
     * 设置 [订单时间]
     */
    public void setMmdate(Timestamp mmdate) {
        this.mmdate = mmdate;
        this.modify("mmdate", mmdate);
    }

    /**
     * 格式化日期 [订单时间]
     */
    public String formatMmdate() {
        if (this.mmdate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(mmdate);
    }
    /**
     * 设置 [工作流版本]
     */
    public void setWfversion(String wfversion) {
        this.wfversion = wfversion;
        this.modify("wfversion", wfversion);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfmmstep(String wfmmstep) {
        this.wfmmstep = wfmmstep;
        this.modify("wfmmstep", wfmmstep);
    }

    /**
     * 设置 [订单类型]
     */
    public void setWfmmtype(String wfmmtype) {
        this.wfmmtype = wfmmtype;
        this.modify("wfmmtype", wfmmtype);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfstate(Integer wfstate) {
        this.wfstate = wfstate;
        this.modify("wfstate", wfstate);
    }

    /**
     * 设置 [多模式流程名称]
     */
    public void setIbizsample0005name(String ibizsample0005name) {
        this.ibizsample0005name = ibizsample0005name;
        this.modify("ibizsample0005name", ibizsample0005name);
    }

    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [状态]
     */
    public void setWfmmstate(String wfmmstate) {
        this.wfmmstate = wfmmstate;
        this.modify("wfmmstate", wfmmstate);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0005id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


