package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[示例实体03]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0003", resultMap = "IBIZSample0003ResultMap")
public class IBIZSample0003 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 名称
     */
    @TableField(value = "ibizsample0003name")
    @JSONField(name = "ibizsample0003name")
    @JsonProperty("ibizsample0003name")
    private String ibizsample0003name;
    /**
     * 备注
     */
    @TableField(value = "memo")
    @JSONField(name = "memo")
    @JsonProperty("memo")
    private String memo;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * FIELD01
     */
    @TableField(value = "field01")
    @JSONField(name = "field01")
    @JsonProperty("field01")
    private String field01;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * IBIZSAMPLE0003标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0003id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0003id")
    @JsonProperty("ibizsample0003id")
    private String ibizsample0003id;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 上级
     */
    @TableField(exist = false)
    @JSONField(name = "pibizsample0003name")
    @JsonProperty("pibizsample0003name")
    private String pibizsample0003name;
    /**
     * IBIZSAMPLE0003标识
     */
    @TableField(value = "pibizsample0003id")
    @JSONField(name = "pibizsample0003id")
    @JsonProperty("pibizsample0003id")
    private String pibizsample0003id;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.sample.domain.IBIZSample0003 pibizsample0003;



    /**
     * 设置 [名称]
     */
    public void setIbizsample0003name(String ibizsample0003name) {
        this.ibizsample0003name = ibizsample0003name;
        this.modify("ibizsample0003name", ibizsample0003name);
    }

    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [FIELD01]
     */
    public void setField01(String field01) {
        this.field01 = field01;
        this.modify("field01", field01);
    }

    /**
     * 设置 [IBIZSAMPLE0003标识]
     */
    public void setPibizsample0003id(String pibizsample0003id) {
        this.pibizsample0003id = pibizsample0003id;
        this.modify("pibizsample0003id", pibizsample0003id);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0003id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


