package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[扩展编辑器]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZAPPEXTENDEDITOR", resultMap = "IBIZAPPEXTENDEDITORResultMap")
public class IBIZAPPEXTENDEDITOR extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 扩展编辑器名称
     */
    @TableField(value = "ibizappextendeditorname")
    @JSONField(name = "ibizappextendeditorname")
    @JsonProperty("ibizappextendeditorname")
    private String ibizappextendeditorname;
    /**
     * 扩展编辑器标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizappextendeditorid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizappextendeditorid")
    @JsonProperty("ibizappextendeditorid")
    private String ibizappextendeditorid;
    /**
     * 扩展标识
     */
    @TableField(value = "extensionflag")
    @JSONField(name = "extensionflag")
    @JsonProperty("extensionflag")
    private String extensionflag;
    /**
     * 文档地址
     */
    @TableField(value = "documentaddress")
    @JSONField(name = "documentaddress")
    @JsonProperty("documentaddress")
    private String documentaddress;
    /**
     * 扩展编辑器描述
     */
    @TableField(value = "extendeditordescription")
    @JSONField(name = "extendeditordescription")
    @JsonProperty("extendeditordescription")
    private String extendeditordescription;
    /**
     * 数量
     */
    @TableField(value = "amount")
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Integer amount;
    /**
     * 扩展编辑器类型
     */
    @TableField(value = "extendeditortype")
    @JSONField(name = "extendeditortype")
    @JsonProperty("extendeditortype")
    private String extendeditortype;



    /**
     * 设置 [扩展编辑器名称]
     */
    public void setIbizappextendeditorname(String ibizappextendeditorname) {
        this.ibizappextendeditorname = ibizappextendeditorname;
        this.modify("ibizappextendeditorname", ibizappextendeditorname);
    }

    /**
     * 设置 [扩展标识]
     */
    public void setExtensionflag(String extensionflag) {
        this.extensionflag = extensionflag;
        this.modify("extensionflag", extensionflag);
    }

    /**
     * 设置 [文档地址]
     */
    public void setDocumentaddress(String documentaddress) {
        this.documentaddress = documentaddress;
        this.modify("documentaddress", documentaddress);
    }

    /**
     * 设置 [扩展编辑器描述]
     */
    public void setExtendeditordescription(String extendeditordescription) {
        this.extendeditordescription = extendeditordescription;
        this.modify("extendeditordescription", extendeditordescription);
    }

    /**
     * 设置 [数量]
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [扩展编辑器类型]
     */
    public void setExtendeditortype(String extendeditortype) {
        this.extendeditortype = extendeditortype;
        this.modify("extendeditortype", extendeditortype);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizappextendeditorid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


