package cn.ibizlab.core.sample.service.logic.impl;

import java.util.Map;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieContainer;
import cn.ibizlab.core.sample.service.logic.IIBIZSample0019UpdateYGNameLogic;
import cn.ibizlab.core.sample.domain.IBIZSample0019;

/**
 * 关系型数据实体[UpdateYGName] 对象
 */
@Slf4j
@Service
public class IBIZSample0019UpdateYGNameLogicImpl implements IIBIZSample0019UpdateYGNameLogic {

    @Autowired
    private KieContainer kieContainer;


    @Autowired
    private cn.ibizlab.core.sample.service.IIBIZSample0019Service iBzSysDefaultService;

    public cn.ibizlab.core.sample.service.IIBIZSample0019Service getIBzSysDefaultService() {
        return this.iBzSysDefaultService;
    }

    @Override
    public void execute(IBIZSample0019 et) {

        KieSession kieSession = null;
        try {
            kieSession = kieContainer.newKieSession();
            kieSession.insert(et); 
            kieSession.setGlobal("ibizsample0019updateygnamedefault", et);
            kieSession.setGlobal("iBzSysIbizsample0019DefaultService", iBzSysDefaultService);
            kieSession.setGlobal("curuser", cn.ibizlab.util.security.AuthenticationUser.getAuthenticationUser());
            kieSession.startProcess("cn.ibizlab.core.sample.service.logic.ibizsample0019updateygname");

        } catch (Exception e) {
            throw new RuntimeException("执行[更新员工名称]处理逻辑发生异常" + e);
        } finally {
            if(kieSession != null) {
                kieSession.destroy();
            }
        }
    }
}
