package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0013;
import cn.ibizlab.core.sample.filter.IBIZSample0013SearchContext;
import cn.ibizlab.core.sample.service.IIBIZSample0013Service;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZSample0013Mapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[订单明细] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0013ServiceImpl")
public class IBIZSample0013ServiceImpl extends ServiceImpl<IBIZSample0013Mapper, IBIZSample0013> implements IIBIZSample0013Service {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZSample0012Service ibizsample0012Service;
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZUNIProductService ibizuniproductService;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZSample0013 et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0013id()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZSample0013> list) {
        list.forEach(item->fillParentData(item));
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZSample0013 et) {
        fillParentData(et);
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizsample0013id", et.getIbizsample0013id()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0013id()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZSample0013> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZSample0013 get(String key) {
        IBIZSample0013 et = getById(key);
        if(et == null){
            et = new IBIZSample0013();
            et.setIbizsample0013id(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZSample0013 getDraft(IBIZSample0013 et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(IBIZSample0013 et) {
        return (!ObjectUtils.isEmpty(et.getIbizsample0013id())) && (!Objects.isNull(this.getById(et.getIbizsample0013id())));
    }
    @Override
    @Transactional
    public boolean save(IBIZSample0013 et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZSample0013 et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZSample0013> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZSample0013> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<IBIZSample0013> selectByIbizsample0012id(String ibizsample0012id) {
        return baseMapper.selectByIbizsample0012id(ibizsample0012id);
    }
    @Override
    public void resetByIbizsample0012id(String ibizsample0012id) {
        this.update(new UpdateWrapper<IBIZSample0013>().set("ibizsample0012id",null).eq("ibizsample0012id",ibizsample0012id));
    }

    @Override
    public void resetByIbizsample0012id(Collection<String> ids) {
        this.update(new UpdateWrapper<IBIZSample0013>().set("ibizsample0012id",null).in("ibizsample0012id",ids));
    }

    @Override
    public void removeByIbizsample0012id(String ibizsample0012id) {
        this.remove(new QueryWrapper<IBIZSample0013>().eq("ibizsample0012id",ibizsample0012id));
    }

	@Override
    public List<IBIZSample0013> selectByIbizuniproductid(String ibizuniproductid) {
        return baseMapper.selectByIbizuniproductid(ibizuniproductid);
    }
    @Override
    public void removeByIbizuniproductid(String ibizuniproductid) {
        this.remove(new QueryWrapper<IBIZSample0013>().eq("ibizuniproductid",ibizuniproductid));
    }


    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZSample0013> searchDefault(IBIZSample0013SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0013> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0013>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(IBIZSample0013 et){
        //实体关系[DER1N_IBIZSAMPLE0013_IBIZSAMPLE0012_IBIZSAMPLE0012ID]
        if(!ObjectUtils.isEmpty(et.getIbizsample0012id())){
            cn.ibizlab.core.sample.domain.IBIZSample0012 ibizsample0012=et.getIbizsample0012();
            if(ObjectUtils.isEmpty(ibizsample0012)){
                cn.ibizlab.core.sample.domain.IBIZSample0012 majorEntity=ibizsample0012Service.get(et.getIbizsample0012id());
                et.setIbizsample0012(majorEntity);
                ibizsample0012=majorEntity;
            }
            et.setIbizsample0012name(ibizsample0012.getIbizsample0012name());
        }
        //实体关系[DER1N_IBIZSAMPLE0013_IBIZUNIPRODUCT_IBIZUNIPRODUCTID]
        if(!ObjectUtils.isEmpty(et.getIbizuniproductid())){
            cn.ibizlab.core.sample.domain.IBIZUNIProduct ibizuniproduct=et.getIbizuniproduct();
            if(ObjectUtils.isEmpty(ibizuniproduct)){
                cn.ibizlab.core.sample.domain.IBIZUNIProduct majorEntity=ibizuniproductService.get(et.getIbizuniproductid());
                et.setIbizuniproduct(majorEntity);
                ibizuniproduct=majorEntity;
            }
            et.setUnit(ibizuniproduct.getUnit());
            et.setIbizuniproductname(ibizuniproduct.getIbizuniproductname());
            et.setUnitprice(ibizuniproduct.getUnitprice());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZSample0013> getIbizsample0013ByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZSample0013> getIbizsample0013ByEntities(List<IBIZSample0013> entities) {
        List ids =new ArrayList();
        for(IBIZSample0013 entity : entities){
            Serializable id=entity.getIbizsample0013id();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



