package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0001;
import cn.ibizlab.core.sample.filter.IBIZSample0001SearchContext;
import cn.ibizlab.core.sample.service.IIBIZSample0001Service;

import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.helper.DEFieldCacheMap;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import cn.ibizlab.core.sample.mapper.IBIZSample0001Mapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

/**
 * 实体[示例实体01] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0001ServiceImpl")
public class IBIZSample0001ServiceImpl extends ServiceImpl<IBIZSample0001Mapper, IBIZSample0001> implements IIBIZSample0001Service {

    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.service.IIBIZSample0002Service ibizsample0002Service;

    protected int batchSize = 500;

    @Override
    @Transactional
    public boolean create(IBIZSample0001 et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0001id()), et);
        return true;
    }

    @Override
    @Transactional
    public void createBatch(List<IBIZSample0001> list) {
        list.forEach(item->fillParentData(item));
        this.saveBatch(list, batchSize);
    }

    @Override
    @Transactional
    public boolean update(IBIZSample0001 et) {
        fillParentData(et);
        if(!update(et, (Wrapper) et.getUpdateWrapper(true).eq("ibizsample0001id", et.getIbizsample0001id()))) {
            return false;
        }
        CachedBeanCopier.copy(get(et.getIbizsample0001id()), et);
        return true;
    }

    @Override
    @Transactional
    public void updateBatch(List<IBIZSample0001> list) {
        list.forEach(item->fillParentData(item));
        updateBatchById(list, batchSize);
    }

    @Override
    @Transactional
    public boolean remove(String key) {
        boolean result = removeById(key);
        return result ;
    }

    @Override
    @Transactional
    public void removeBatch(Collection<String> idList) {
        removeByIds(idList);
    }

    @Override
    @Transactional
    public IBIZSample0001 get(String key) {
        IBIZSample0001 et = getById(key);
        if(et == null){
            et = new IBIZSample0001();
            et.setIbizsample0001id(key);
        }
        else {
        }
        return et;
    }

    @Override
    public IBIZSample0001 getDraft(IBIZSample0001 et) {
        fillParentData(et);
        return et;
    }

    @Override
    public boolean checkKey(IBIZSample0001 et) {
        return (!ObjectUtils.isEmpty(et.getIbizsample0001id())) && (!Objects.isNull(this.getById(et.getIbizsample0001id())));
    }
    @Override
    @Transactional
    public boolean save(IBIZSample0001 et) {
        if(!saveOrUpdate(et)) {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveOrUpdate(IBIZSample0001 et) {
        if (null == et) {
            return false;
        } else {
            return checkKey(et) ? this.update(et) : this.create(et);
        }
    }

    @Override
    @Transactional
    public boolean saveBatch(Collection<IBIZSample0001> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
        return true;
    }

    @Override
    @Transactional
    public void saveBatch(List<IBIZSample0001> list) {
        list.forEach(item->fillParentData(item));
        saveOrUpdateBatch(list,batchSize);
    }


	@Override
    public List<IBIZSample0001> selectByIbizsample0002id(String ibizsample0002id) {
        return baseMapper.selectByIbizsample0002id(ibizsample0002id);
    }
    @Override
    public void removeByIbizsample0002id(String ibizsample0002id) {
        this.remove(new QueryWrapper<IBIZSample0001>().eq("ibizsample0002id",ibizsample0002id));
    }


    /**
     * 查询集合 DEFAULT
     */
    @Override
    public Page<IBIZSample0001> searchDefault(IBIZSample0001SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0001> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0001>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }



    /**
     * 为当前实体填充父数据（外键值文本、外键值附加数据）
     * @param et
     */
    private void fillParentData(IBIZSample0001 et){
        //实体关系[DER1N_IBIZSAMPLE0001_IBIZSAMPLE0002_IBIZSAMPLE0002ID]
        if(!ObjectUtils.isEmpty(et.getIbizsample0002id())){
            cn.ibizlab.core.sample.domain.IBIZSample0002 sample0002Sample00011N=et.getSample0002Sample00011N();
            if(ObjectUtils.isEmpty(sample0002Sample00011N)){
                cn.ibizlab.core.sample.domain.IBIZSample0002 majorEntity=ibizsample0002Service.get(et.getIbizsample0002id());
                et.setSample0002Sample00011N(majorEntity);
                sample0002Sample00011N=majorEntity;
            }
            et.setIbizsample0002name(sample0002Sample00011N.getIbizsample0002name());
        }
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

    @Override
    public List<IBIZSample0001> getIbizsample0001ByIds(List<String> ids) {
         return this.listByIds(ids);
    }

    @Override
    public List<IBIZSample0001> getIbizsample0001ByEntities(List<IBIZSample0001> entities) {
        List ids =new ArrayList();
        for(IBIZSample0001 entity : entities){
            Serializable id=entity.getIbizsample0001id();
            if(!ObjectUtils.isEmpty(id)){
                ids.add(id);
            }
        }
        if(ids.size()>0) {
            return this.listByIds(ids);
        }
        else {
            return entities;
        }
    }




}



