package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.MicroComponent;
import cn.ibizlab.core.sample.filter.MicroComponentSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[MicroComponent] 服务对象接口
 */
public interface IMicroComponentService extends IService<MicroComponent> {

    boolean create(MicroComponent et);
    void createBatch(List<MicroComponent> list);
    boolean update(MicroComponent et);
    void updateBatch(List<MicroComponent> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    MicroComponent get(String key);
    MicroComponent getDraft(MicroComponent et);
    boolean checkKey(MicroComponent et);
    boolean save(MicroComponent et);
    void saveBatch(List<MicroComponent> list);
    Page<MicroComponent> searchDefault(MicroComponentSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<MicroComponent> getMicrocomponentByIds(List<String> ids);
    List<MicroComponent> getMicrocomponentByEntities(List<MicroComponent> entities);
}


