package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import cn.ibizlab.core.sample.filter.IBIZUNIProductSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZUNIProduct] 服务对象接口
 */
public interface IIBIZUNIProductService extends IService<IBIZUNIProduct> {

    boolean create(IBIZUNIProduct et);
    void createBatch(List<IBIZUNIProduct> list);
    boolean update(IBIZUNIProduct et);
    void updateBatch(List<IBIZUNIProduct> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZUNIProduct get(String key);
    IBIZUNIProduct getDraft(IBIZUNIProduct et);
    boolean checkKey(IBIZUNIProduct et);
    boolean save(IBIZUNIProduct et);
    void saveBatch(List<IBIZUNIProduct> list);
    Page<IBIZUNIProduct> searchDefault(IBIZUNIProductSearchContext context);
    Page<IBIZUNIProduct> searchIndexDER(IBIZUNIProductSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZUNIProduct> getIbizuniproductByIds(List<String> ids);
    List<IBIZUNIProduct> getIbizuniproductByEntities(List<IBIZUNIProduct> entities);
}


