package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZSoftwareSuit;
import cn.ibizlab.core.sample.filter.IBIZSoftwareSuitSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZSoftwareSuit] 服务对象接口
 */
public interface IIBIZSoftwareSuitService extends IService<IBIZSoftwareSuit> {

    boolean create(IBIZSoftwareSuit et);
    void createBatch(List<IBIZSoftwareSuit> list);
    boolean update(IBIZSoftwareSuit et);
    void updateBatch(List<IBIZSoftwareSuit> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZSoftwareSuit get(String key);
    IBIZSoftwareSuit getDraft(IBIZSoftwareSuit et);
    boolean checkKey(IBIZSoftwareSuit et);
    boolean save(IBIZSoftwareSuit et);
    void saveBatch(List<IBIZSoftwareSuit> list);
    Page<IBIZSoftwareSuit> searchDefault(IBIZSoftwareSuitSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZSoftwareSuit> getIbizsoftwaresuitByIds(List<String> ids);
    List<IBIZSoftwareSuit> getIbizsoftwaresuitByEntities(List<IBIZSoftwareSuit> entities);
}


