package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZSample;
import cn.ibizlab.core.sample.filter.IBIZSampleSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZSample] 服务对象接口
 */
public interface IIBIZSampleService extends IService<IBIZSample> {

    boolean create(IBIZSample et);
    void createBatch(List<IBIZSample> list);
    boolean update(IBIZSample et);
    void updateBatch(List<IBIZSample> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZSample get(String key);
    IBIZSample getDraft(IBIZSample et);
    boolean checkKey(IBIZSample et);
    boolean save(IBIZSample et);
    void saveBatch(List<IBIZSample> list);
    Page<IBIZSample> searchDefault(IBIZSampleSearchContext context);
    Page<IBIZSample> searchFormType(IBIZSampleSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZSample> getIbizsampleByIds(List<String> ids);
    List<IBIZSample> getIbizsampleByEntities(List<IBIZSample> entities);
}


