package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZSample0011;
import cn.ibizlab.core.sample.filter.IBIZSample0011SearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZSample0011] 服务对象接口
 */
public interface IIBIZSample0011Service extends IService<IBIZSample0011> {

    boolean create(IBIZSample0011 et);
    void createBatch(List<IBIZSample0011> list);
    boolean update(IBIZSample0011 et);
    void updateBatch(List<IBIZSample0011> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZSample0011 get(String key);
    IBIZSample0011 getDraft(IBIZSample0011 et);
    boolean checkKey(IBIZSample0011 et);
    boolean save(IBIZSample0011 et);
    void saveBatch(List<IBIZSample0011> list);
    Page<IBIZSample0011> searchDefault(IBIZSample0011SearchContext context);
    List<IBIZSample0011> selectByIbizsample0010id(String ibizsample0010id);
    void removeByIbizsample0010id(Collection<String> ids);
    void removeByIbizsample0010id(String ibizsample0010id);
    List<IBIZSample0011> selectByIbizuniproductid(String ibizuniproductid);
    void removeByIbizuniproductid(String ibizuniproductid);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZSample0011> getIbizsample0011ByIds(List<String> ids);
    List<IBIZSample0011> getIbizsample0011ByEntities(List<IBIZSample0011> entities);
}


