package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZSample0003;
import cn.ibizlab.core.sample.filter.IBIZSample0003SearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZSample0003] 服务对象接口
 */
public interface IIBIZSample0003Service extends IService<IBIZSample0003> {

    boolean create(IBIZSample0003 et);
    void createBatch(List<IBIZSample0003> list);
    boolean update(IBIZSample0003 et);
    void updateBatch(List<IBIZSample0003> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZSample0003 get(String key);
    IBIZSample0003 getDraft(IBIZSample0003 et);
    boolean checkKey(IBIZSample0003 et);
    boolean save(IBIZSample0003 et);
    void saveBatch(List<IBIZSample0003> list);
    Page<IBIZSample0003> searchCurData(IBIZSample0003SearchContext context);
    Page<IBIZSample0003> searchDefault(IBIZSample0003SearchContext context);
    Page<IBIZSample0003> searchTopData(IBIZSample0003SearchContext context);
    List<IBIZSample0003> selectByPibizsample0003id(String ibizsample0003id);
    void removeByPibizsample0003id(Collection<String> ids);
    void removeByPibizsample0003id(String ibizsample0003id);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZSample0003> getIbizsample0003ByIds(List<String> ids);
    List<IBIZSample0003> getIbizsample0003ByEntities(List<IBIZSample0003> entities);
}


