package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZHardware;
import cn.ibizlab.core.sample.filter.IBIZHardwareSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZHardware] 服务对象接口
 */
public interface IIBIZHardwareService extends IService<IBIZHardware> {

    boolean create(IBIZHardware et);
    void createBatch(List<IBIZHardware> list);
    boolean update(IBIZHardware et);
    void updateBatch(List<IBIZHardware> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZHardware get(String key);
    IBIZHardware getDraft(IBIZHardware et);
    boolean checkKey(IBIZHardware et);
    boolean save(IBIZHardware et);
    void saveBatch(List<IBIZHardware> list);
    Page<IBIZHardware> searchDefault(IBIZHardwareSearchContext context);
    Page<IBIZHardware> searchIndexDER(IBIZHardwareSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZHardware> getIbizhardwareByIds(List<String> ids);
    List<IBIZHardware> getIbizhardwareByEntities(List<IBIZHardware> entities);
}


