package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.IBIZAPPEDITOR;
import cn.ibizlab.core.sample.filter.IBIZAPPEDITORSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[IBIZAPPEDITOR] 服务对象接口
 */
public interface IIBIZAPPEDITORService extends IService<IBIZAPPEDITOR> {

    boolean create(IBIZAPPEDITOR et);
    void createBatch(List<IBIZAPPEDITOR> list);
    boolean update(IBIZAPPEDITOR et);
    void updateBatch(List<IBIZAPPEDITOR> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    IBIZAPPEDITOR get(String key);
    IBIZAPPEDITOR getDraft(IBIZAPPEDITOR et);
    boolean checkKey(IBIZAPPEDITOR et);
    boolean save(IBIZAPPEDITOR et);
    void saveBatch(List<IBIZAPPEDITOR> list);
    Page<IBIZAPPEDITOR> searchDefault(IBIZAPPEDITORSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<IBIZAPPEDITOR> getIbizappeditorByIds(List<String> ids);
    List<IBIZAPPEDITOR> getIbizappeditorByEntities(List<IBIZAPPEDITOR> entities);
}


