package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.DYNADASHBOARD;
import cn.ibizlab.core.sample.filter.DYNADASHBOARDSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[DYNADASHBOARD] 服务对象接口
 */
public interface IDYNADASHBOARDService extends IService<DYNADASHBOARD> {

    boolean create(DYNADASHBOARD et);
    void createBatch(List<DYNADASHBOARD> list);
    boolean update(DYNADASHBOARD et);
    void updateBatch(List<DYNADASHBOARD> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DYNADASHBOARD get(String key);
    DYNADASHBOARD getDraft(DYNADASHBOARD et);
    boolean checkKey(DYNADASHBOARD et);
    boolean save(DYNADASHBOARD et);
    void saveBatch(List<DYNADASHBOARD> list);
    Page<DYNADASHBOARD> searchDefault(DYNADASHBOARDSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<DYNADASHBOARD> getDynadashboardByIds(List<String> ids);
    List<DYNADASHBOARD> getDynadashboardByEntities(List<DYNADASHBOARD> entities);
}


