package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.sample.domain.APPKANBAN;
import cn.ibizlab.core.sample.filter.APPKANBANSearchContext;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 实体[APPKANBAN] 服务对象接口
 */
public interface IAPPKANBANService extends IService<APPKANBAN> {

    boolean create(APPKANBAN et);
    void createBatch(List<APPKANBAN> list);
    boolean update(APPKANBAN et);
    void updateBatch(List<APPKANBAN> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    APPKANBAN get(String key);
    APPKANBAN getDraft(APPKANBAN et);
    boolean checkKey(APPKANBAN et);
    boolean save(APPKANBAN et);
    void saveBatch(List<APPKANBAN> list);
    Page<APPKANBAN> searchDefault(APPKANBANSearchContext context);
    /**
     *自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);
    /**
     *自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);

    List<APPKANBAN> getAppkanbanByIds(List<String> ids);
    List<APPKANBAN> getAppkanbanByEntities(List<APPKANBAN> entities);
}


