

package cn.ibizlab.core.sample.mapping;

import org.mapstruct.*;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import java.util.List;

@Mapper(componentModel = "spring", uses = {})
public interface IBIZHardwareInheritMapping {

    @Mappings({
        @Mapping(source ="ibizhardwareid",target = "ibizuniproductid"),
        @Mapping(source ="ibizhardwarename",target = "ibizuniproductname"),
        @Mapping(target ="focusNull",ignore = true),
    })
    IBIZUNIProduct toIbizuniproduct(IBIZHardware ibizhardware);

    @Mappings({
        @Mapping(source ="ibizuniproductid" ,target = "ibizhardwareid"),
        @Mapping(source ="ibizuniproductname" ,target = "ibizhardwarename"),
        @Mapping(target ="focusNull",ignore = true),
    })
    IBIZHardware toIbizhardware(IBIZUNIProduct ibizuniproduct);

    List<IBIZUNIProduct> toIbizuniproduct(List<IBIZHardware> ibizhardware);

    List<IBIZHardware> toIbizhardware(List<IBIZUNIProduct> ibizuniproduct);

}


