package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
/**
 * 关系型数据实体[IBIZUNIProduct] 查询条件对象
 */
@Slf4j
@Data
public class IBIZUNIProductSearchContext extends QueryWrapperContext<IBIZUNIProduct> {

	private String n_ibizuniproductname_like;//[产品名称]
	public void setN_ibizuniproductname_like(String n_ibizuniproductname_like) {
        this.n_ibizuniproductname_like = n_ibizuniproductname_like;
        if(!ObjectUtils.isEmpty(this.n_ibizuniproductname_like)){
            this.getSearchCond().like("ibizuniproductname", n_ibizuniproductname_like);
        }
    }
	private String n_ibizuniproducttype_eq;//[分组类型]
	public void setN_ibizuniproducttype_eq(String n_ibizuniproducttype_eq) {
        this.n_ibizuniproducttype_eq = n_ibizuniproducttype_eq;
        if(!ObjectUtils.isEmpty(this.n_ibizuniproducttype_eq)){
            this.getSearchCond().eq("ibizuniproducttype", n_ibizuniproducttype_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizuniproductname", query)
            );
		 }
	}
}



