package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.*;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0021;
/**
 * 关系型数据实体[IBIZSample0021] 查询条件对象
 */
@Slf4j
@Data
public class IBIZSample0021SearchContext extends QueryWrapperContext<IBIZSample0021> {

	private String n_ibizsample0021name_like;//[订单名称]
	public void setN_ibizsample0021name_like(String n_ibizsample0021name_like) {
        this.n_ibizsample0021name_like = n_ibizsample0021name_like;
        if(!ObjectUtils.isEmpty(this.n_ibizsample0021name_like)){
            this.getSearchCond().like("ibizsample0021name", n_ibizsample0021name_like);
        }
    }
	private String n_orderstate_eq;//[订单状态]
	public void setN_orderstate_eq(String n_orderstate_eq) {
        this.n_orderstate_eq = n_orderstate_eq;
        if(!ObjectUtils.isEmpty(this.n_orderstate_eq)){
            this.getSearchCond().eq("orderstate", n_orderstate_eq);
        }
    }

    /**
	 * 启用快速搜索
	 */
    @Override
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0021name", query)
            );
		 }
	}
}



