package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[订单]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0021", resultMap = "IBIZSample0021ResultMap")
public class IBIZSample0021 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 订单标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0021id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0021id")
    @JsonProperty("ibizsample0021id")
    private String ibizsample0021id;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 订单名称
     */
    @TableField(value = "ibizsample0021name")
    @JSONField(name = "ibizsample0021name")
    @JsonProperty("ibizsample0021name")
    private String ibizsample0021name;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 订单状态
     */
    @DEField(defaultValue = "10")
    @TableField(value = "orderstate")
    @JSONField(name = "orderstate")
    @JsonProperty("orderstate")
    private String orderstate;
    /**
     * 订单时间
     */
    @TableField(value = "ordertime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ordertime", format = "yyyy-MM-dd")
    @JsonProperty("ordertime")
    private Timestamp ordertime;
    /**
     * 备注
     */
    @TableField(value = "memo")
    @JSONField(name = "memo")
    @JsonProperty("memo")
    private String memo;
    /**
     * CURORGID
     */
    @TableField(value = "curorgid")
    @JSONField(name = "curorgid")
    @JsonProperty("curorgid")
    private String curorgid;
    /**
     * CURDEPTID
     */
    @TableField(value = "curdeptid")
    @JSONField(name = "curdeptid")
    @JsonProperty("curdeptid")
    private String curdeptid;
    /**
     * 总计
     */
    @TableField(value = "amount")
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Double amount;



    /**
     * 设置 [订单名称]
     */
    public void setIbizsample0021name(String ibizsample0021name) {
        this.ibizsample0021name = ibizsample0021name;
        this.modify("ibizsample0021name", ibizsample0021name);
    }

    /**
     * 设置 [订单状态]
     */
    public void setOrderstate(String orderstate) {
        this.orderstate = orderstate;
        this.modify("orderstate", orderstate);
    }

    /**
     * 设置 [订单时间]
     */
    public void setOrdertime(Timestamp ordertime) {
        this.ordertime = ordertime;
        this.modify("ordertime", ordertime);
    }

    /**
     * 格式化日期 [订单时间]
     */
    public String formatOrdertime() {
        if (this.ordertime == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(ordertime);
    }
    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [CURORGID]
     */
    public void setCurorgid(String curorgid) {
        this.curorgid = curorgid;
        this.modify("curorgid", curorgid);
    }

    /**
     * 设置 [CURDEPTID]
     */
    public void setCurdeptid(String curdeptid) {
        this.curdeptid = curdeptid;
        this.modify("curdeptid", curdeptid);
    }

    /**
     * 设置 [总计]
     */
    public void setAmount(Double amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0021id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


