package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[商品价格明细]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0009", resultMap = "IBIZSample0009ResultMap")
public class IBIZSample0009 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 日期
     */
    @TableField(value = "date")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "date", format = "yyyy-MM-dd")
    @JsonProperty("date")
    private Timestamp date;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 收盘
     */
    @TableField(value = "sp")
    @JSONField(name = "sp")
    @JsonProperty("sp")
    private BigDecimal sp;
    /**
     * 商品价格明细名称
     */
    @TableField(value = "ibizsample0009name")
    @JSONField(name = "ibizsample0009name")
    @JsonProperty("ibizsample0009name")
    private String ibizsample0009name;
    /**
     * 商品价格明细标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0009id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0009id")
    @JsonProperty("ibizsample0009id")
    private String ibizsample0009id;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 商品名称
     */
    @TableField(value = "spmc")
    @JSONField(name = "spmc")
    @JsonProperty("spmc")
    private String spmc;
    /**
     * 盘低
     */
    @TableField(value = "pd")
    @JSONField(name = "pd")
    @JsonProperty("pd")
    private BigDecimal pd;
    /**
     * 统计
     */
    @TableField(exist = false)
    @JSONField(name = "tj")
    @JsonProperty("tj")
    private String tj;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 盘高
     */
    @TableField(value = "pg")
    @JSONField(name = "pg")
    @JsonProperty("pg")
    private BigDecimal pg;
    /**
     * 开盘
     */
    @TableField(value = "kp")
    @JSONField(name = "kp")
    @JsonProperty("kp")
    private BigDecimal kp;



    /**
     * 设置 [日期]
     */
    public void setDate(Timestamp date) {
        this.date = date;
        this.modify("date", date);
    }

    /**
     * 格式化日期 [日期]
     */
    public String formatDate() {
        if (this.date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }
    /**
     * 设置 [收盘]
     */
    public void setSp(BigDecimal sp) {
        this.sp = sp;
        this.modify("sp", sp);
    }

    /**
     * 设置 [商品价格明细名称]
     */
    public void setIbizsample0009name(String ibizsample0009name) {
        this.ibizsample0009name = ibizsample0009name;
        this.modify("ibizsample0009name", ibizsample0009name);
    }

    /**
     * 设置 [商品名称]
     */
    public void setSpmc(String spmc) {
        this.spmc = spmc;
        this.modify("spmc", spmc);
    }

    /**
     * 设置 [盘低]
     */
    public void setPd(BigDecimal pd) {
        this.pd = pd;
        this.modify("pd", pd);
    }

    /**
     * 设置 [盘高]
     */
    public void setPg(BigDecimal pg) {
        this.pg = pg;
        this.modify("pg", pg);
    }

    /**
     * 设置 [开盘]
     */
    public void setKp(BigDecimal kp) {
        this.kp = kp;
        this.modify("kp", kp);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0009id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


