package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[示例实体02]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0002", resultMap = "IBIZSample0002ResultMap")
public class IBIZSample0002 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 实体
     */
    @TableField(value = "de")
    @JSONField(name = "de")
    @JsonProperty("de")
    private String de;
    /**
     * 实体数据量
     */
    @TableField(value = "denum")
    @JSONField(name = "denum")
    @JsonProperty("denum")
    private Integer denum;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 首页图表数据源名称
     */
    @TableField(value = "ibizsample0002name")
    @JSONField(name = "ibizsample0002name")
    @JsonProperty("ibizsample0002name")
    private String ibizsample0002name;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 首页图表数据源标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0002id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0002id")
    @JsonProperty("ibizsample0002id")
    private String ibizsample0002id;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;



    /**
     * 设置 [实体]
     */
    public void setDe(String de) {
        this.de = de;
        this.modify("de", de);
    }

    /**
     * 设置 [实体数据量]
     */
    public void setDenum(Integer denum) {
        this.denum = denum;
        this.modify("denum", denum);
    }

    /**
     * 设置 [首页图表数据源名称]
     */
    public void setIbizsample0002name(String ibizsample0002name) {
        this.ibizsample0002name = ibizsample0002name;
        this.modify("ibizsample0002name", ibizsample0002name);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0002id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


