package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[示例实体01]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0001", resultMap = "IBIZSample0001ResultMap")
public class IBIZSample0001 extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 文本，可指定长度
     */
    @TableField(value = "field01")
    @JSONField(name = "field01")
    @JsonProperty("field01")
    private String field01;
    /**
     * 长文本，长度1000
     */
    @TableField(value = "field02")
    @JSONField(name = "field02")
    @JsonProperty("field02")
    private String field02;
    /**
     * 长文本，没有长度限制
     */
    @TableField(value = "field03")
    @JSONField(name = "field03")
    @JsonProperty("field03")
    private String field03;
    /**
     * HTML文本，没有长度限制
     */
    @TableField(value = "field04")
    @JSONField(name = "field04")
    @JsonProperty("field04")
    private String field04;
    /**
     * 整型
     */
    @TableField(value = "field05")
    @JSONField(name = "field05")
    @JsonProperty("field05")
    private Integer field05;
    /**
     * 浮点
     */
    @TableField(value = "field06")
    @JSONField(name = "field06")
    @JsonProperty("field06")
    private Double field06;
    /**
     * 数值
     */
    @TableField(value = "field07")
    @JSONField(name = "field07")
    @JsonProperty("field07")
    private BigDecimal field07;
    /**
     * 日期时间型
     */
    @TableField(value = "field08")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "field08", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("field08")
    private Timestamp field08;
    /**
     * 日期型
     */
    @TableField(value = "field09")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "field09", format = "yyyy-MM-dd")
    @JsonProperty("field09")
    private Timestamp field09;
    /**
     * 时间型
     */
    @TableField(value = "field10")
    @JsonFormat(pattern = "HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "field10", format = "HH:mm:ss")
    @JsonProperty("field10")
    private Timestamp field10;
    /**
     * 是否逻辑
     */
    @TableField(value = "field11")
    @JSONField(name = "field11")
    @JsonProperty("field11")
    private Integer field11;
    /**
     * 真假逻辑
     */
    @TableField(value = "field12")
    @JSONField(name = "field12")
    @JsonProperty("field12")
    private Integer field12;
    /**
     * 单项选择(数值)
     */
    @TableField(value = "field13")
    @JSONField(name = "field13")
    @JsonProperty("field13")
    private Integer field13;
    /**
     * 单项选择(文本值)
     */
    @TableField(value = "field14")
    @JSONField(name = "field14")
    @JsonProperty("field14")
    private String field14;
    /**
     * 多项选择(数值)
     */
    @TableField(value = "field15")
    @JSONField(name = "field15")
    @JsonProperty("field15")
    private Integer field15;
    /**
     * 多项选择(文本值)
     */
    @TableField(value = "field16")
    @JSONField(name = "field16")
    @JsonProperty("field16")
    private String field16;
    /**
     * 选择项文本
     */
    @TableField(value = "field24")
    @JSONField(name = "field24")
    @JsonProperty("field24")
    private String field24;
    /**
     * 数字串业务标识，数字类型，用户可见
     */
    @TableField(value = "field17")
    @JSONField(name = "field17")
    @JsonProperty("field17")
    private Integer field17;
    /**
     * 字符串业务标识，文本类型，用户可见
     */
    @TableField(value = "field18")
    @JSONField(name = "field18")
    @JsonProperty("field18")
    private String field18;
    /**
     * 货币
     */
    @TableField(value = "field19")
    @JSONField(name = "field19")
    @JsonProperty("field19")
    private String field19;
    /**
     * 货币单位
     */
    @TableField(value = "field20")
    @JSONField(name = "field20")
    @JsonProperty("field20")
    private String field20;
    /**
     * 出生日期
     */
    @TableField(value = "field21")
    @JSONField(name = "field21")
    @JsonProperty("field21")
    private Timestamp field21;
    /**
     * 电子邮件
     */
    @TableField(value = "field22")
    @JSONField(name = "field22")
    @JsonProperty("field22")
    private String field22;
    /**
     * 工作流处理状态
     */
    @TableField(value = "field27")
    @JSONField(name = "field27")
    @JsonProperty("field27")
    private Integer field27;
    /**
     * 名称
     */
    @TableField(value = "ibizsample0001name")
    @JSONField(name = "ibizsample0001name")
    @JsonProperty("ibizsample0001name")
    private String ibizsample0001name;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * IBIZSAMPLE0001标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizsample0001id", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizsample0001id")
    @JsonProperty("ibizsample0001id")
    private String ibizsample0001id;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 大整型
     */
    @TableField(value = "field")
    @JSONField(name = "field")
    @JsonProperty("field")
    private Long field;
    /**
     * 大数值
     */
    @TableField(value = "field2")
    @JSONField(name = "field2")
    @JsonProperty("field2")
    private BigDecimal field2;
    /**
     * 首页图表数据源标识
     */
    @TableField(value = "ibizsample0002id")
    @JSONField(name = "ibizsample0002id")
    @JsonProperty("ibizsample0002id")
    private String ibizsample0002id;
    /**
     * 示例实体02名称
     */
    @TableField(value = "ibizsample0002name")
    @JSONField(name = "ibizsample0002name")
    @JsonProperty("ibizsample0002name")
    private String ibizsample0002name;
    /**
     * 颜色
     */
    @TableField(value = "color")
    @JSONField(name = "color")
    @JsonProperty("color")
    private String color;
    /**
     * IP地址
     */
    @TableField(value = "ip")
    @JSONField(name = "ip")
    @JsonProperty("ip")
    private String ip;
    /**
     * 地址信息
     */
    @TableField(value = "address")
    @JSONField(name = "address")
    @JsonProperty("address")
    private String address;
    /**
     * 经度
     */
    @TableField(value = "longitude")
    @JSONField(name = "longitude")
    @JsonProperty("longitude")
    private String longitude;
    /**
     * 纬度
     */
    @TableField(value = "latitude")
    @JSONField(name = "latitude")
    @JsonProperty("latitude")
    private String latitude;
    /**
     * 图片
     */
    @TableField(value = "picture")
    @JSONField(name = "picture")
    @JsonProperty("picture")
    private String picture;
    /**
     * 城市
     */
    @TableField(value = "city")
    @JSONField(name = "city")
    @JsonProperty("city")
    private String city;
    /**
     * 磁盘图片
     */
    @TableField(value = "diskimg")
    @JSONField(name = "diskimg")
    @JsonProperty("diskimg")
    private String diskimg;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.sample.domain.IBIZSample0002 sample0002Sample00011N;



    /**
     * 设置 [文本，可指定长度]
     */
    public void setField01(String field01) {
        this.field01 = field01;
        this.modify("field01", field01);
    }

    /**
     * 设置 [长文本，长度1000]
     */
    public void setField02(String field02) {
        this.field02 = field02;
        this.modify("field02", field02);
    }

    /**
     * 设置 [长文本，没有长度限制]
     */
    public void setField03(String field03) {
        this.field03 = field03;
        this.modify("field03", field03);
    }

    /**
     * 设置 [HTML文本，没有长度限制]
     */
    public void setField04(String field04) {
        this.field04 = field04;
        this.modify("field04", field04);
    }

    /**
     * 设置 [整型]
     */
    public void setField05(Integer field05) {
        this.field05 = field05;
        this.modify("field05", field05);
    }

    /**
     * 设置 [浮点]
     */
    public void setField06(Double field06) {
        this.field06 = field06;
        this.modify("field06", field06);
    }

    /**
     * 设置 [数值]
     */
    public void setField07(BigDecimal field07) {
        this.field07 = field07;
        this.modify("field07", field07);
    }

    /**
     * 设置 [日期时间型]
     */
    public void setField08(Timestamp field08) {
        this.field08 = field08;
        this.modify("field08", field08);
    }

    /**
     * 格式化日期 [日期时间型]
     */
    public String formatField08() {
        if (this.field08 == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(field08);
    }
    /**
     * 设置 [日期型]
     */
    public void setField09(Timestamp field09) {
        this.field09 = field09;
        this.modify("field09", field09);
    }

    /**
     * 格式化日期 [日期型]
     */
    public String formatField09() {
        if (this.field09 == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(field09);
    }
    /**
     * 设置 [时间型]
     */
    public void setField10(Timestamp field10) {
        this.field10 = field10;
        this.modify("field10", field10);
    }

    /**
     * 格式化日期 [时间型]
     */
    public String formatField10() {
        if (this.field10 == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        return sdf.format(field10);
    }
    /**
     * 设置 [是否逻辑]
     */
    public void setField11(Integer field11) {
        this.field11 = field11;
        this.modify("field11", field11);
    }

    /**
     * 设置 [真假逻辑]
     */
    public void setField12(Integer field12) {
        this.field12 = field12;
        this.modify("field12", field12);
    }

    /**
     * 设置 [单项选择(数值)]
     */
    public void setField13(Integer field13) {
        this.field13 = field13;
        this.modify("field13", field13);
    }

    /**
     * 设置 [单项选择(文本值)]
     */
    public void setField14(String field14) {
        this.field14 = field14;
        this.modify("field14", field14);
    }

    /**
     * 设置 [多项选择(数值)]
     */
    public void setField15(Integer field15) {
        this.field15 = field15;
        this.modify("field15", field15);
    }

    /**
     * 设置 [多项选择(文本值)]
     */
    public void setField16(String field16) {
        this.field16 = field16;
        this.modify("field16", field16);
    }

    /**
     * 设置 [选择项文本]
     */
    public void setField24(String field24) {
        this.field24 = field24;
        this.modify("field24", field24);
    }

    /**
     * 设置 [数字串业务标识，数字类型，用户可见]
     */
    public void setField17(Integer field17) {
        this.field17 = field17;
        this.modify("field17", field17);
    }

    /**
     * 设置 [字符串业务标识，文本类型，用户可见]
     */
    public void setField18(String field18) {
        this.field18 = field18;
        this.modify("field18", field18);
    }

    /**
     * 设置 [货币]
     */
    public void setField19(String field19) {
        this.field19 = field19;
        this.modify("field19", field19);
    }

    /**
     * 设置 [货币单位]
     */
    public void setField20(String field20) {
        this.field20 = field20;
        this.modify("field20", field20);
    }

    /**
     * 设置 [出生日期]
     */
    public void setField21(Timestamp field21) {
        this.field21 = field21;
        this.modify("field21", field21);
    }

    /**
     * 设置 [电子邮件]
     */
    public void setField22(String field22) {
        this.field22 = field22;
        this.modify("field22", field22);
    }

    /**
     * 设置 [工作流处理状态]
     */
    public void setField27(Integer field27) {
        this.field27 = field27;
        this.modify("field27", field27);
    }

    /**
     * 设置 [名称]
     */
    public void setIbizsample0001name(String ibizsample0001name) {
        this.ibizsample0001name = ibizsample0001name;
        this.modify("ibizsample0001name", ibizsample0001name);
    }

    /**
     * 设置 [大整型]
     */
    public void setField(Long field) {
        this.field = field;
        this.modify("field", field);
    }

    /**
     * 设置 [大数值]
     */
    public void setField2(BigDecimal field2) {
        this.field2 = field2;
        this.modify("field2", field2);
    }

    /**
     * 设置 [首页图表数据源标识]
     */
    public void setIbizsample0002id(String ibizsample0002id) {
        this.ibizsample0002id = ibizsample0002id;
        this.modify("ibizsample0002id", ibizsample0002id);
    }

    /**
     * 设置 [示例实体02名称]
     */
    public void setIbizsample0002name(String ibizsample0002name) {
        this.ibizsample0002name = ibizsample0002name;
        this.modify("ibizsample0002name", ibizsample0002name);
    }

    /**
     * 设置 [颜色]
     */
    public void setColor(String color) {
        this.color = color;
        this.modify("color", color);
    }

    /**
     * 设置 [IP地址]
     */
    public void setIp(String ip) {
        this.ip = ip;
        this.modify("ip", ip);
    }

    /**
     * 设置 [地址信息]
     */
    public void setAddress(String address) {
        this.address = address;
        this.modify("address", address);
    }

    /**
     * 设置 [经度]
     */
    public void setLongitude(String longitude) {
        this.longitude = longitude;
        this.modify("longitude", longitude);
    }

    /**
     * 设置 [纬度]
     */
    public void setLatitude(String latitude) {
        this.latitude = latitude;
        this.modify("latitude", latitude);
    }

    /**
     * 设置 [图片]
     */
    public void setPicture(String picture) {
        this.picture = picture;
        this.modify("picture", picture);
    }

    /**
     * 设置 [城市]
     */
    public void setCity(String city) {
        this.city = city;
        this.modify("city", city);
    }

    /**
     * 设置 [磁盘图片]
     */
    public void setDiskimg(String diskimg) {
        this.diskimg = diskimg;
        this.modify("diskimg", diskimg);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0001id");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


