package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[订单]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZORDER", resultMap = "IBIZOrderResultMap")
public class IBIZOrder extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 图片
     */
    @TableField(value = "tp")
    @JSONField(name = "tp")
    @JsonProperty("tp")
    private String tp;
    /**
     * 订单结束时间
     */
    @TableField(value = "endtime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "endtime", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("endtime")
    private Timestamp endtime;
    /**
     * 工作流状态
     */
    @TableField(value = "wfstate")
    @JSONField(name = "wfstate")
    @JsonProperty("wfstate")
    private Integer wfstate;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 审批意见
     */
    @TableField(value = "opinion")
    @JSONField(name = "opinion")
    @JsonProperty("opinion")
    private String opinion;
    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 订单类型
     */
    @TableField(value = "ordertype")
    @JSONField(name = "ordertype")
    @JsonProperty("ordertype")
    private String ordertype;
    /**
     * 明细数
     */
    @TableField(value = "detailnum")
    @JSONField(name = "detailnum")
    @JsonProperty("detailnum")
    private Integer detailnum;
    /**
     * 工作流实例
     */
    @TableField(value = "wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    private String wfinstanceid;
    /**
     * 总计
     */
    @TableField(value = "amount")
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Double amount;
    /**
     * 订单编号
     */
    @DEField(dupCheck = DupCheck.ALL)
    @TableField(value = "orderuid")
    @JSONField(name = "orderuid")
    @JsonProperty("orderuid")
    private String orderuid;
    /**
     * 订单标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizorderid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizorderid")
    @JsonProperty("ibizorderid")
    private String ibizorderid;
    /**
     * 订单状态
     */
    @DEField(defaultValue = "10")
    @TableField(value = "orderstate")
    @JSONField(name = "orderstate")
    @JsonProperty("orderstate")
    private String orderstate;
    /**
     * 订单开始时间
     */
    @TableField(value = "starttime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "starttime", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("starttime")
    private Timestamp starttime;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 工作流步骤
     */
    @TableField(value = "wfstep")
    @JSONField(name = "wfstep")
    @JsonProperty("wfstep")
    private String wfstep;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 订单名称
     */
    @TableField(value = "ibizordername")
    @JSONField(name = "ibizordername")
    @JsonProperty("ibizordername")
    private String ibizordername;
    /**
     * 订单时间
     */
    @TableField(value = "ordertime")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ordertime", format = "yyyy-MM-dd")
    @JsonProperty("ordertime")
    private Timestamp ordertime;
    /**
     * 备注
     */
    @TableField(value = "memo")
    @JSONField(name = "memo")
    @JsonProperty("memo")
    private String memo;
    /**
     * 客户名称
     */
    @TableField(exist = false)
    @JSONField(name = "ibizcustomername")
    @JsonProperty("ibizcustomername")
    private String ibizcustomername;
    /**
     * 客户标识
     */
    @TableField(value = "ibizcustomerid")
    @JSONField(name = "ibizcustomerid")
    @JsonProperty("ibizcustomerid")
    private String ibizcustomerid;

    /**
     * 
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private cn.ibizlab.core.sample.domain.IBIZCustomer ibizcustomer;



    /**
     * 设置 [图片]
     */
    public void setTp(String tp) {
        this.tp = tp;
        this.modify("tp", tp);
    }

    /**
     * 设置 [订单结束时间]
     */
    public void setEndtime(Timestamp endtime) {
        this.endtime = endtime;
        this.modify("endtime", endtime);
    }

    /**
     * 格式化日期 [订单结束时间]
     */
    public String formatEndtime() {
        if (this.endtime == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(endtime);
    }
    /**
     * 设置 [工作流状态]
     */
    public void setWfstate(Integer wfstate) {
        this.wfstate = wfstate;
        this.modify("wfstate", wfstate);
    }

    /**
     * 设置 [审批意见]
     */
    public void setOpinion(String opinion) {
        this.opinion = opinion;
        this.modify("opinion", opinion);
    }

    /**
     * 设置 [订单类型]
     */
    public void setOrdertype(String ordertype) {
        this.ordertype = ordertype;
        this.modify("ordertype", ordertype);
    }

    /**
     * 设置 [明细数]
     */
    public void setDetailnum(Integer detailnum) {
        this.detailnum = detailnum;
        this.modify("detailnum", detailnum);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfinstanceid(String wfinstanceid) {
        this.wfinstanceid = wfinstanceid;
        this.modify("wfinstanceid", wfinstanceid);
    }

    /**
     * 设置 [总计]
     */
    public void setAmount(Double amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [订单编号]
     */
    public void setOrderuid(String orderuid) {
        this.orderuid = orderuid;
        this.modify("orderuid", orderuid);
    }

    /**
     * 设置 [订单状态]
     */
    public void setOrderstate(String orderstate) {
        this.orderstate = orderstate;
        this.modify("orderstate", orderstate);
    }

    /**
     * 设置 [订单开始时间]
     */
    public void setStarttime(Timestamp starttime) {
        this.starttime = starttime;
        this.modify("starttime", starttime);
    }

    /**
     * 格式化日期 [订单开始时间]
     */
    public String formatStarttime() {
        if (this.starttime == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(starttime);
    }
    /**
     * 设置 [工作流步骤]
     */
    public void setWfstep(String wfstep) {
        this.wfstep = wfstep;
        this.modify("wfstep", wfstep);
    }

    /**
     * 设置 [订单名称]
     */
    public void setIbizordername(String ibizordername) {
        this.ibizordername = ibizordername;
        this.modify("ibizordername", ibizordername);
    }

    /**
     * 设置 [订单时间]
     */
    public void setOrdertime(Timestamp ordertime) {
        this.ordertime = ordertime;
        this.modify("ordertime", ordertime);
    }

    /**
     * 格式化日期 [订单时间]
     */
    public String formatOrdertime() {
        if (this.ordertime == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(ordertime);
    }
    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [客户标识]
     */
    public void setIbizcustomerid(String ibizcustomerid) {
        this.ibizcustomerid = ibizcustomerid;
        this.modify("ibizcustomerid", ibizcustomerid);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizorderid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


