package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[客户管理]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "", resultMap = "IBIZCustomerMGResultMap")
public class IBIZCustomerMG extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 客户标识
     */
    @DEField(isKeyField = true)
    @TableField(exist = false)
    @JSONField(name = "ibizcustomerid")
    @JsonProperty("ibizcustomerid")
    private String ibizcustomerid;
    /**
     * 客户名称
     */
    @TableField(exist = false)
    @JSONField(name = "ibizcustomername")
    @JsonProperty("ibizcustomername")
    private String ibizcustomername;
    /**
     * 开户银行号
     */
    @TableField(exist = false)
    @JSONField(name = "bankaccountnum")
    @JsonProperty("bankaccountnum")
    private String bankaccountnum;
    /**
     * 开户行
     */
    @TableField(exist = false)
    @JSONField(name = "bankname")
    @JsonProperty("bankname")
    private String bankname;
    /**
     * 公司地址
     */
    @TableField(exist = false)
    @JSONField(name = "address")
    @JsonProperty("address")
    private String address;
    /**
     * 客户编号
     */
    @TableField(exist = false)
    @JSONField(name = "customeruid")
    @JsonProperty("customeruid")
    private String customeruid;




    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizcustomerid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


