package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import cn.ibizlab.util.domain.EntityMP;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

/**
 * 实体[账户]
 */
@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZACCOUNT", resultMap = "IBIZAccountResultMap")
public class IBIZAccount extends EntityMP implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 更新时间
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEDATE)
    @TableField(value = "updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;
    /**
     * 更新人
     */
    @DEField(preType = DEPredefinedFieldType.UPDATEMAN)
    @TableField(value = "updateman")
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;
    /**
     * 开户行
     */
    @TableField(value = "bankname")
    @JSONField(name = "bankname")
    @JsonProperty("bankname")
    private String bankname;
    /**
     * 账户名称
     */
    @TableField(value = "ibizaccountname")
    @JSONField(name = "ibizaccountname")
    @JsonProperty("ibizaccountname")
    private String ibizaccountname;
    /**
     * 建立人
     */
    @DEField(preType = DEPredefinedFieldType.CREATEMAN)
    @TableField(value = "createman", fill = FieldFill.INSERT)
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;
    /**
     * 建立时间
     */
    @DEField(preType = DEPredefinedFieldType.CREATEDATE)
    @TableField(value = "createdate", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 开户银行号
     */
    @TableField(value = "bankaccountnum")
    @JSONField(name = "bankaccountnum")
    @JsonProperty("bankaccountnum")
    private String bankaccountnum;
    /**
     * 账户标识
     */
    @DEField(isKeyField = true)
    @TableId(value = "ibizaccountid", type = IdType.ASSIGN_UUID)
    @JSONField(name = "ibizaccountid")
    @JsonProperty("ibizaccountid")
    private String ibizaccountid;



    /**
     * 设置 [开户行]
     */
    public void setBankname(String bankname) {
        this.bankname = bankname;
        this.modify("bankname", bankname);
    }

    /**
     * 设置 [账户名称]
     */
    public void setIbizaccountname(String ibizaccountname) {
        this.ibizaccountname = ibizaccountname;
        this.modify("ibizaccountname", ibizaccountname);
    }

    /**
     * 设置 [开户银行号]
     */
    public void setBankaccountnum(String bankaccountnum) {
        this.bankaccountnum = bankaccountnum;
        this.modify("bankaccountnum", bankaccountnum);
    }


    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizaccountid");
        return super.copyTo(targetEntity, bIncEmpty);
    }
}


