package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0001;
import cn.ibizlab.core.sample.service.IIBIZSample0001Service;
import cn.ibizlab.core.sample.filter.IBIZSample0001SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"示例实体01" })
@RestController("DemoAPI-ibizsample0001")
@RequestMapping("")
public class IBIZSample0001Resource {

    @Autowired
    public IIBIZSample0001Service ibizsample0001Service;

    @Autowired
    @Lazy
    public IBIZSample0001Mapping ibizsample0001Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0001Mapping.toDomain(#ibizsample0001dto),'DemoSys-IBIZSample0001-Create')")
    @ApiOperation(value = "新建示例实体01", tags = {"示例实体01" },  notes = "新建示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0001s")
    public ResponseEntity<IBIZSample0001DTO> create(@Validated @RequestBody IBIZSample0001DTO ibizsample0001dto) {
        IBIZSample0001 domain = ibizsample0001Mapping.toDomain(ibizsample0001dto);
		ibizsample0001Service.create(domain);
        IBIZSample0001DTO dto = ibizsample0001Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Mapping.toDomain(#ibizsample0001dtos),'DemoSys-IBIZSample0001-Create')")
    @ApiOperation(value = "批量新建示例实体01", tags = {"示例实体01" },  notes = "批量新建示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0001s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0001DTO> ibizsample0001dtos) {
        ibizsample0001Service.createBatch(ibizsample0001Mapping.toDomain(ibizsample0001dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0001" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0001Service.get(#ibizsample0001_id),'DemoSys-IBIZSample0001-Update')")
    @ApiOperation(value = "更新示例实体01", tags = {"示例实体01" },  notes = "更新示例实体01")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0001s/{ibizsample0001_id}")
    public ResponseEntity<IBIZSample0001DTO> update(@PathVariable("ibizsample0001_id") String ibizsample0001_id, @RequestBody IBIZSample0001DTO ibizsample0001dto) {
		IBIZSample0001 domain  = ibizsample0001Mapping.toDomain(ibizsample0001dto);
        domain .setIbizsample0001id(ibizsample0001_id);
		ibizsample0001Service.update(domain );
		IBIZSample0001DTO dto = ibizsample0001Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Service.getIbizsample0001ByEntities(this.ibizsample0001Mapping.toDomain(#ibizsample0001dtos)),'DemoSys-IBIZSample0001-Update')")
    @ApiOperation(value = "批量更新示例实体01", tags = {"示例实体01" },  notes = "批量更新示例实体01")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0001s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0001DTO> ibizsample0001dtos) {
        ibizsample0001Service.updateBatch(ibizsample0001Mapping.toDomain(ibizsample0001dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Service.get(#ibizsample0001_id),'DemoSys-IBIZSample0001-Remove')")
    @ApiOperation(value = "删除示例实体01", tags = {"示例实体01" },  notes = "删除示例实体01")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0001s/{ibizsample0001_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0001_id") String ibizsample0001_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0001Service.remove(ibizsample0001_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Service.getIbizsample0001ByIds(#ids),'DemoSys-IBIZSample0001-Remove')")
    @ApiOperation(value = "批量删除示例实体01", tags = {"示例实体01" },  notes = "批量删除示例实体01")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0001s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0001Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0001Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0001-Get')")
    @ApiOperation(value = "获取示例实体01", tags = {"示例实体01" },  notes = "获取示例实体01")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0001s/{ibizsample0001_id}")
    public ResponseEntity<IBIZSample0001DTO> get(@PathVariable("ibizsample0001_id") String ibizsample0001_id) {
        IBIZSample0001 domain = ibizsample0001Service.get(ibizsample0001_id);
        IBIZSample0001DTO dto = ibizsample0001Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取示例实体01草稿", tags = {"示例实体01" },  notes = "获取示例实体01草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0001s/getdraft")
    public ResponseEntity<IBIZSample0001DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0001Mapping.toDto(ibizsample0001Service.getDraft(new IBIZSample0001())));
    }

    @ApiOperation(value = "检查示例实体01", tags = {"示例实体01" },  notes = "检查示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0001s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0001DTO ibizsample0001dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0001Service.checkKey(ibizsample0001Mapping.toDomain(ibizsample0001dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Mapping.toDomain(#ibizsample0001dto),'DemoSys-IBIZSample0001-Save')")
    @ApiOperation(value = "保存示例实体01", tags = {"示例实体01" },  notes = "保存示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0001s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0001DTO ibizsample0001dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0001Service.save(ibizsample0001Mapping.toDomain(ibizsample0001dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Mapping.toDomain(#ibizsample0001dtos),'DemoSys-IBIZSample0001-Save')")
    @ApiOperation(value = "批量保存示例实体01", tags = {"示例实体01" },  notes = "批量保存示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0001s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0001DTO> ibizsample0001dtos) {
        ibizsample0001Service.saveBatch(ibizsample0001Mapping.toDomain(ibizsample0001dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0001-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"示例实体01" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0001s/fetchdefault")
	public ResponseEntity<List<IBIZSample0001DTO>> fetchDefault(IBIZSample0001SearchContext context) {
        Page<IBIZSample0001> domains = ibizsample0001Service.searchDefault(context) ;
        List<IBIZSample0001DTO> list = ibizsample0001Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0001-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"示例实体01" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0001s/searchdefault")
	public ResponseEntity<Page<IBIZSample0001DTO>> searchDefault(@RequestBody IBIZSample0001SearchContext context) {
        Page<IBIZSample0001> domains = ibizsample0001Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0001Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    @PreAuthorize("hasPermission(this.ibizsample0001Mapping.toDomain(#ibizsample0001dto),'DemoSys-IBIZSample0001-Create')")
    @ApiOperation(value = "根据示例实体02建立示例实体01", tags = {"示例实体01" },  notes = "根据示例实体02建立示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s")
    public ResponseEntity<IBIZSample0001DTO> createByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id, @RequestBody IBIZSample0001DTO ibizsample0001dto) {
        IBIZSample0001 domain = ibizsample0001Mapping.toDomain(ibizsample0001dto);
        domain.setIbizsample0002id(ibizsample0002_id);
		ibizsample0001Service.create(domain);
        IBIZSample0001DTO dto = ibizsample0001Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Mapping.toDomain(#ibizsample0001dtos),'DemoSys-IBIZSample0001-Create')")
    @ApiOperation(value = "根据示例实体02批量建立示例实体01", tags = {"示例实体01" },  notes = "根据示例实体02批量建立示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/batch")
    public ResponseEntity<Boolean> createBatchByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id, @RequestBody List<IBIZSample0001DTO> ibizsample0001dtos) {
        List<IBIZSample0001> domainlist=ibizsample0001Mapping.toDomain(ibizsample0001dtos);
        for(IBIZSample0001 domain:domainlist){
            domain.setIbizsample0002id(ibizsample0002_id);
        }
        ibizsample0001Service.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0001" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0001Service.get(#ibizsample0001_id),'DemoSys-IBIZSample0001-Update')")
    @ApiOperation(value = "根据示例实体02更新示例实体01", tags = {"示例实体01" },  notes = "根据示例实体02更新示例实体01")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/{ibizsample0001_id}")
    public ResponseEntity<IBIZSample0001DTO> updateByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id, @PathVariable("ibizsample0001_id") String ibizsample0001_id, @RequestBody IBIZSample0001DTO ibizsample0001dto) {
        IBIZSample0001 domain = ibizsample0001Mapping.toDomain(ibizsample0001dto);
        domain.setIbizsample0002id(ibizsample0002_id);
        domain.setIbizsample0001id(ibizsample0001_id);
		ibizsample0001Service.update(domain);
        IBIZSample0001DTO dto = ibizsample0001Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Service.getIbizsample0001ByEntities(this.ibizsample0001Mapping.toDomain(#ibizsample0001dtos)),'DemoSys-IBIZSample0001-Update')")
    @ApiOperation(value = "根据示例实体02批量更新示例实体01", tags = {"示例实体01" },  notes = "根据示例实体02批量更新示例实体01")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/batch")
    public ResponseEntity<Boolean> updateBatchByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id, @RequestBody List<IBIZSample0001DTO> ibizsample0001dtos) {
        List<IBIZSample0001> domainlist=ibizsample0001Mapping.toDomain(ibizsample0001dtos);
        for(IBIZSample0001 domain:domainlist){
            domain.setIbizsample0002id(ibizsample0002_id);
        }
        ibizsample0001Service.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Service.get(#ibizsample0001_id),'DemoSys-IBIZSample0001-Remove')")
    @ApiOperation(value = "根据示例实体02删除示例实体01", tags = {"示例实体01" },  notes = "根据示例实体02删除示例实体01")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/{ibizsample0001_id}")
    public ResponseEntity<Boolean> removeByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id, @PathVariable("ibizsample0001_id") String ibizsample0001_id) {
		return ResponseEntity.status(HttpStatus.OK).body(ibizsample0001Service.remove(ibizsample0001_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Service.getIbizsample0001ByIds(#ids),'DemoSys-IBIZSample0001-Remove')")
    @ApiOperation(value = "根据示例实体02批量删除示例实体01", tags = {"示例实体01" },  notes = "根据示例实体02批量删除示例实体01")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/batch")
    public ResponseEntity<Boolean> removeBatchByIBIZSample0002(@RequestBody List<String> ids) {
        ibizsample0001Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0001Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0001-Get')")
    @ApiOperation(value = "根据示例实体02获取示例实体01", tags = {"示例实体01" },  notes = "根据示例实体02获取示例实体01")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/{ibizsample0001_id}")
    public ResponseEntity<IBIZSample0001DTO> getByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id, @PathVariable("ibizsample0001_id") String ibizsample0001_id) {
        IBIZSample0001 domain = ibizsample0001Service.get(ibizsample0001_id);
        IBIZSample0001DTO dto = ibizsample0001Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据示例实体02获取示例实体01草稿", tags = {"示例实体01" },  notes = "根据示例实体02获取示例实体01草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/getdraft")
    public ResponseEntity<IBIZSample0001DTO> getDraftByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id) {
        IBIZSample0001 domain = new IBIZSample0001();
        domain.setIbizsample0002id(ibizsample0002_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0001Mapping.toDto(ibizsample0001Service.getDraft(domain)));
    }

    @ApiOperation(value = "根据示例实体02检查示例实体01", tags = {"示例实体01" },  notes = "根据示例实体02检查示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/checkkey")
    public ResponseEntity<Boolean> checkKeyByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id, @RequestBody IBIZSample0001DTO ibizsample0001dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0001Service.checkKey(ibizsample0001Mapping.toDomain(ibizsample0001dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Mapping.toDomain(#ibizsample0001dto),'DemoSys-IBIZSample0001-Save')")
    @ApiOperation(value = "根据示例实体02保存示例实体01", tags = {"示例实体01" },  notes = "根据示例实体02保存示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/save")
    public ResponseEntity<Boolean> saveByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id, @RequestBody IBIZSample0001DTO ibizsample0001dto) {
        IBIZSample0001 domain = ibizsample0001Mapping.toDomain(ibizsample0001dto);
        domain.setIbizsample0002id(ibizsample0002_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0001Service.save(domain));
    }

    @PreAuthorize("hasPermission(this.ibizsample0001Mapping.toDomain(#ibizsample0001dtos),'DemoSys-IBIZSample0001-Save')")
    @ApiOperation(value = "根据示例实体02批量保存示例实体01", tags = {"示例实体01" },  notes = "根据示例实体02批量保存示例实体01")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/savebatch")
    public ResponseEntity<Boolean> saveBatchByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id, @RequestBody List<IBIZSample0001DTO> ibizsample0001dtos) {
        List<IBIZSample0001> domainlist=ibizsample0001Mapping.toDomain(ibizsample0001dtos);
        for(IBIZSample0001 domain:domainlist){
             domain.setIbizsample0002id(ibizsample0002_id);
        }
        ibizsample0001Service.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0001-Get')")
	@ApiOperation(value = "根据示例实体02获取DEFAULT", tags = {"示例实体01" } ,notes = "根据示例实体02获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/fetchdefault")
	public ResponseEntity<List<IBIZSample0001DTO>> fetchIBIZSample0001DefaultByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id,IBIZSample0001SearchContext context) {
        context.setN_ibizsample0002id_eq(ibizsample0002_id);
        Page<IBIZSample0001> domains = ibizsample0001Service.searchDefault(context) ;
        List<IBIZSample0001DTO> list = ibizsample0001Mapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0001-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0001-Get')")
	@ApiOperation(value = "根据示例实体02查询DEFAULT", tags = {"示例实体01" } ,notes = "根据示例实体02查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0002s/{ibizsample0002_id}/ibizsample0001s/searchdefault")
	public ResponseEntity<Page<IBIZSample0001DTO>> searchIBIZSample0001DefaultByIBIZSample0002(@PathVariable("ibizsample0002_id") String ibizsample0002_id, @RequestBody IBIZSample0001SearchContext context) {
        context.setN_ibizsample0002id_eq(ibizsample0002_id);
        Page<IBIZSample0001> domains = ibizsample0001Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0001Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

