package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZOrderDTO]
 */
@Data
public class IBIZOrderDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [TP]
     *
     */
    @JSONField(name = "tp")
    @JsonProperty("tp")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String tp;

    /**
     * 属性 [ENDTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "endtime" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("endtime")
    private Timestamp endtime;

    /**
     * 属性 [WFSTATE]
     *
     */
    @JSONField(name = "wfstate")
    @JsonProperty("wfstate")
    private Integer wfstate;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [OPINION]
     *
     */
    @JSONField(name = "opinion")
    @JsonProperty("opinion")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    private String opinion;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [ORDERTYPE]
     *
     */
    @JSONField(name = "ordertype")
    @JsonProperty("ordertype")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String ordertype;

    /**
     * 属性 [DETAILNUM]
     *
     */
    @JSONField(name = "detailnum")
    @JsonProperty("detailnum")
    private Integer detailnum;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @JSONField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String wfinstanceid;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Double amount;

    /**
     * 属性 [ORDERUID]
     *
     */
    @JSONField(name = "orderuid")
    @JsonProperty("orderuid")
    @NotBlank(message = "[订单编号]不允许为空!")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String orderuid;

    /**
     * 属性 [IBIZORDERID]
     *
     */
    @JSONField(name = "ibizorderid")
    @JsonProperty("ibizorderid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizorderid;

    /**
     * 属性 [ORDERSTATE]
     *
     */
    @JSONField(name = "orderstate")
    @JsonProperty("orderstate")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String orderstate;

    /**
     * 属性 [STARTTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "starttime" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("starttime")
    private Timestamp starttime;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [WFSTEP]
     *
     */
    @JSONField(name = "wfstep")
    @JsonProperty("wfstep")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String wfstep;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [IBIZORDERNAME]
     *
     */
    @JSONField(name = "ibizordername")
    @JsonProperty("ibizordername")
    @NotBlank(message = "[订单名称]不允许为空!")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizordername;

    /**
     * 属性 [ORDERTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "ordertime" , format="yyyy-MM-dd")
    @JsonProperty("ordertime")
    private Timestamp ordertime;

    /**
     * 属性 [MEMO]
     *
     */
    @JSONField(name = "memo")
    @JsonProperty("memo")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    private String memo;

    /**
     * 属性 [IBIZCUSTOMERNAME]
     *
     */
    @JSONField(name = "ibizcustomername")
    @JsonProperty("ibizcustomername")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizcustomername;

    /**
     * 属性 [IBIZCUSTOMERID]
     *
     */
    @JSONField(name = "ibizcustomerid")
    @JsonProperty("ibizcustomerid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizcustomerid;


    /**
     * 设置 [TP]
     */
    public void setTp(String  tp){
        this.tp = tp ;
        this.modify("tp",tp);
    }

    /**
     * 设置 [ENDTIME]
     */
    public void setEndtime(Timestamp  endtime){
        this.endtime = endtime ;
        this.modify("endtime",endtime);
    }

    /**
     * 设置 [WFSTATE]
     */
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.modify("wfstate",wfstate);
    }

    /**
     * 设置 [OPINION]
     */
    public void setOpinion(String  opinion){
        this.opinion = opinion ;
        this.modify("opinion",opinion);
    }

    /**
     * 设置 [ORDERTYPE]
     */
    public void setOrdertype(String  ordertype){
        this.ordertype = ordertype ;
        this.modify("ordertype",ordertype);
    }

    /**
     * 设置 [DETAILNUM]
     */
    public void setDetailnum(Integer  detailnum){
        this.detailnum = detailnum ;
        this.modify("detailnum",detailnum);
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.modify("wfinstanceid",wfinstanceid);
    }

    /**
     * 设置 [AMOUNT]
     */
    public void setAmount(Double  amount){
        this.amount = amount ;
        this.modify("amount",amount);
    }

    /**
     * 设置 [ORDERUID]
     */
    public void setOrderuid(String  orderuid){
        this.orderuid = orderuid ;
        this.modify("orderuid",orderuid);
    }

    /**
     * 设置 [ORDERSTATE]
     */
    public void setOrderstate(String  orderstate){
        this.orderstate = orderstate ;
        this.modify("orderstate",orderstate);
    }

    /**
     * 设置 [STARTTIME]
     */
    public void setStarttime(Timestamp  starttime){
        this.starttime = starttime ;
        this.modify("starttime",starttime);
    }

    /**
     * 设置 [WFSTEP]
     */
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.modify("wfstep",wfstep);
    }

    /**
     * 设置 [IBIZORDERNAME]
     */
    public void setIbizordername(String  ibizordername){
        this.ibizordername = ibizordername ;
        this.modify("ibizordername",ibizordername);
    }

    /**
     * 设置 [ORDERTIME]
     */
    public void setOrdertime(Timestamp  ordertime){
        this.ordertime = ordertime ;
        this.modify("ordertime",ordertime);
    }

    /**
     * 设置 [MEMO]
     */
    public void setMemo(String  memo){
        this.memo = memo ;
        this.modify("memo",memo);
    }

    /**
     * 设置 [IBIZCUSTOMERID]
     */
    public void setIbizcustomerid(String  ibizcustomerid){
        this.ibizcustomerid = ibizcustomerid ;
        this.modify("ibizcustomerid",ibizcustomerid);
    }


}


