package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZSample0020DTO]
 */
@Data
public class IBIZSample0020DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBIZSAMPLE0020NAME]
     *
     */
    @JSONField(name = "ibizsample0020name")
    @JsonProperty("ibizsample0020name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizsample0020name;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [IBIZSAMPLE0020ID]
     *
     */
    @JSONField(name = "ibizsample0020id")
    @JsonProperty("ibizsample0020id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizsample0020id;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [IBIZSAMPLE0019NAME]
     *
     */
    @JSONField(name = "ibizsample0019name")
    @JsonProperty("ibizsample0019name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizsample0019name;

    /**
     * 属性 [IBIZSAMPLE0019ID]
     *
     */
    @JSONField(name = "ibizsample0019id")
    @JsonProperty("ibizsample0019id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizsample0019id;


    /**
     * 设置 [IBIZSAMPLE0020NAME]
     */
    public void setIbizsample0020name(String  ibizsample0020name){
        this.ibizsample0020name = ibizsample0020name ;
        this.modify("ibizsample0020name",ibizsample0020name);
    }

    /**
     * 设置 [IBIZSAMPLE0019NAME]
     */
    public void setIbizsample0019name(String  ibizsample0019name){
        this.ibizsample0019name = ibizsample0019name ;
        this.modify("ibizsample0019name",ibizsample0019name);
    }

    /**
     * 设置 [IBIZSAMPLE0019ID]
     */
    public void setIbizsample0019id(String  ibizsample0019id){
        this.ibizsample0019id = ibizsample0019id ;
        this.modify("ibizsample0019id",ibizsample0019id);
    }


}


