package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZSampleDTO]
 */
@Data
public class IBIZSampleDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [OSLINK4]
     *
     */
    @JSONField(name = "oslink4")
    @JsonProperty("oslink4")
    @Size(min = 0, max = 1000, message = "内容长度必须小于等于[1000]")
    private String oslink4;

    /**
     * 属性 [TITLE1]
     *
     */
    @JSONField(name = "title1")
    @JsonProperty("title1")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String title1;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [IBIZSAMPLENAME]
     *
     */
    @JSONField(name = "ibizsamplename")
    @JsonProperty("ibizsamplename")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizsamplename;

    /**
     * 属性 [OSLINK3]
     *
     */
    @JSONField(name = "oslink3")
    @JsonProperty("oslink3")
    @Size(min = 0, max = 1000, message = "内容长度必须小于等于[1000]")
    private String oslink3;

    /**
     * 属性 [LINK1]
     *
     */
    @JSONField(name = "link1")
    @JsonProperty("link1")
    @Size(min = 0, max = 400, message = "内容长度必须小于等于[400]")
    private String link1;

    /**
     * 属性 [IBIZSAMPLEID]
     *
     */
    @JSONField(name = "ibizsampleid")
    @JsonProperty("ibizsampleid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizsampleid;

    /**
     * 属性 [TITLE6]
     *
     */
    @JSONField(name = "title6")
    @JsonProperty("title6")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String title6;

    /**
     * 属性 [LINK6]
     *
     */
    @JSONField(name = "link6")
    @JsonProperty("link6")
    @Size(min = 0, max = 400, message = "内容长度必须小于等于[400]")
    private String link6;

    /**
     * 属性 [TITLE5]
     *
     */
    @JSONField(name = "title5")
    @JsonProperty("title5")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String title5;

    /**
     * 属性 [TITLE4]
     *
     */
    @JSONField(name = "title4")
    @JsonProperty("title4")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String title4;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [OSLINK1]
     *
     */
    @JSONField(name = "oslink1")
    @JsonProperty("oslink1")
    @Size(min = 0, max = 1000, message = "内容长度必须小于等于[1000]")
    private String oslink1;

    /**
     * 属性 [OSLINK5]
     *
     */
    @JSONField(name = "oslink5")
    @JsonProperty("oslink5")
    @Size(min = 0, max = 1000, message = "内容长度必须小于等于[1000]")
    private String oslink5;

    /**
     * 属性 [OSLINK6]
     *
     */
    @JSONField(name = "oslink6")
    @JsonProperty("oslink6")
    @Size(min = 0, max = 1000, message = "内容长度必须小于等于[1000]")
    private String oslink6;

    /**
     * 属性 [LINK5]
     *
     */
    @JSONField(name = "link5")
    @JsonProperty("link5")
    @Size(min = 0, max = 400, message = "内容长度必须小于等于[400]")
    private String link5;

    /**
     * 属性 [LINK3]
     *
     */
    @JSONField(name = "link3")
    @JsonProperty("link3")
    @Size(min = 0, max = 400, message = "内容长度必须小于等于[400]")
    private String link3;

    /**
     * 属性 [TITLE2]
     *
     */
    @JSONField(name = "title2")
    @JsonProperty("title2")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String title2;

    /**
     * 属性 [OSLINK2]
     *
     */
    @JSONField(name = "oslink2")
    @JsonProperty("oslink2")
    @Size(min = 0, max = 1000, message = "内容长度必须小于等于[1000]")
    private String oslink2;

    /**
     * 属性 [TITLE3]
     *
     */
    @JSONField(name = "title3")
    @JsonProperty("title3")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String title3;

    /**
     * 属性 [LINK4]
     *
     */
    @JSONField(name = "link4")
    @JsonProperty("link4")
    @Size(min = 0, max = 400, message = "内容长度必须小于等于[400]")
    private String link4;

    /**
     * 属性 [LINK2]
     *
     */
    @JSONField(name = "link2")
    @JsonProperty("link2")
    @Size(min = 0, max = 400, message = "内容长度必须小于等于[400]")
    private String link2;

    /**
     * 属性 [SAMPLETYPE]
     *
     */
    @JSONField(name = "sampletype")
    @JsonProperty("sampletype")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String sampletype;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;


    /**
     * 设置 [OSLINK4]
     */
    public void setOslink4(String  oslink4){
        this.oslink4 = oslink4 ;
        this.modify("oslink4",oslink4);
    }

    /**
     * 设置 [TITLE1]
     */
    public void setTitle1(String  title1){
        this.title1 = title1 ;
        this.modify("title1",title1);
    }

    /**
     * 设置 [IBIZSAMPLENAME]
     */
    public void setIbizsamplename(String  ibizsamplename){
        this.ibizsamplename = ibizsamplename ;
        this.modify("ibizsamplename",ibizsamplename);
    }

    /**
     * 设置 [OSLINK3]
     */
    public void setOslink3(String  oslink3){
        this.oslink3 = oslink3 ;
        this.modify("oslink3",oslink3);
    }

    /**
     * 设置 [LINK1]
     */
    public void setLink1(String  link1){
        this.link1 = link1 ;
        this.modify("link1",link1);
    }

    /**
     * 设置 [TITLE6]
     */
    public void setTitle6(String  title6){
        this.title6 = title6 ;
        this.modify("title6",title6);
    }

    /**
     * 设置 [LINK6]
     */
    public void setLink6(String  link6){
        this.link6 = link6 ;
        this.modify("link6",link6);
    }

    /**
     * 设置 [TITLE5]
     */
    public void setTitle5(String  title5){
        this.title5 = title5 ;
        this.modify("title5",title5);
    }

    /**
     * 设置 [TITLE4]
     */
    public void setTitle4(String  title4){
        this.title4 = title4 ;
        this.modify("title4",title4);
    }

    /**
     * 设置 [OSLINK1]
     */
    public void setOslink1(String  oslink1){
        this.oslink1 = oslink1 ;
        this.modify("oslink1",oslink1);
    }

    /**
     * 设置 [OSLINK5]
     */
    public void setOslink5(String  oslink5){
        this.oslink5 = oslink5 ;
        this.modify("oslink5",oslink5);
    }

    /**
     * 设置 [OSLINK6]
     */
    public void setOslink6(String  oslink6){
        this.oslink6 = oslink6 ;
        this.modify("oslink6",oslink6);
    }

    /**
     * 设置 [LINK5]
     */
    public void setLink5(String  link5){
        this.link5 = link5 ;
        this.modify("link5",link5);
    }

    /**
     * 设置 [LINK3]
     */
    public void setLink3(String  link3){
        this.link3 = link3 ;
        this.modify("link3",link3);
    }

    /**
     * 设置 [TITLE2]
     */
    public void setTitle2(String  title2){
        this.title2 = title2 ;
        this.modify("title2",title2);
    }

    /**
     * 设置 [OSLINK2]
     */
    public void setOslink2(String  oslink2){
        this.oslink2 = oslink2 ;
        this.modify("oslink2",oslink2);
    }

    /**
     * 设置 [TITLE3]
     */
    public void setTitle3(String  title3){
        this.title3 = title3 ;
        this.modify("title3",title3);
    }

    /**
     * 设置 [LINK4]
     */
    public void setLink4(String  link4){
        this.link4 = link4 ;
        this.modify("link4",link4);
    }

    /**
     * 设置 [LINK2]
     */
    public void setLink2(String  link2){
        this.link2 = link2 ;
        this.modify("link2",link2);
    }

    /**
     * 设置 [SAMPLETYPE]
     */
    public void setSampletype(String  sampletype){
        this.sampletype = sampletype ;
        this.modify("sampletype",sampletype);
    }


}


