// 基于 @CONTROL/应用菜单/SERVICE.ts.ftl 生成
import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import MainMenuModel from './main-menu-appmenu-model';


/**
 * MainMenu 部件服务对象
 *
 * @export
 * @class MainMenuService
 */
export default class MainMenuService extends ControlService {

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof MainMenuService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of MainMenuService.
     * 
     * @param {*} [opts={}]
     * @memberof MainMenuService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new MainMenuModel();
    }

    /**
     * 获取数据
     *
     * @returns {Promise<any>}
     * @memberof MainMenu
     */
    @Errorlog
    public get(params: any = {}): Promise<any> {
        return Http.getInstance().get('v7/main-menuappmenu', params);
    }

}