import { Http,Util } from '@/utils';
import EntityService from '../entity-service';
import CountMoneyLogic from '@/service/ibizorder-detail/count-money-logic';
import GetUnitAndPriceLogic from '@/service/ibizorder-detail/get-unit-and-price-logic';


/**
 * 订单明细服务对象基类
 * 基于 APP/src/service/%DE_PKGPATH%/%DE_PKGPATH%-service-base.ts.ftl 生成
 * @export
 * @class IBIZOrderDetailServiceBase
 * @extends {EntityServie}
 */
export default class IBIZOrderDetailServiceBase extends EntityService {

    /**
     * Creates an instance of  IBIZOrderDetailServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBIZOrderDetailServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof IBIZOrderDetailServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='ibizorderdetail';
        this.APPDEKEY = 'ibizorderdetailid';
        this.APPDENAME = 'ibizorderdetails';
        this.APPDETEXT = 'ibizorderdetailname';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'demosys';
    }

// 实体接口

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && context.ibizorderdetail){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/ibizorders/${context.ibizorder}/ibizorderdetails/${context.ibizorderdetail}/checkkey`,data,isloading);
            
            return res;
        }
            let res:any = Http.getInstance().post(`/ibizorderdetails/${context.ibizorderdetail}/checkkey`,data,isloading);
            return res;
    }

    /**
     * CountMoney接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async CountMoney(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let appLogic:CountMoneyLogic = new CountMoneyLogic({context:JSON.parse(JSON.stringify(context)),data:JSON.parse(JSON.stringify(data))});
        data = await appLogic.onExecute(context,data,isloading?true:false);
        let res:any ={status:200,data:data};
        return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && true){
            let masterData:any = {};
            Object.assign(data,masterData);
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            let tempContext:any = JSON.parse(JSON.stringify(context));
            let res:any = await Http.getInstance().post(`/ibizorders/${context.ibizorder}/ibizorderdetails`,data,isloading);
                let countmoney:CountMoneyLogic = new CountMoneyLogic({context:JSON.parse(JSON.stringify(context)),data:JSON.parse(JSON.stringify(res)).data});
            let countmoneyData:any = await countmoney.onExecute(context,res.data,isloading?true:false);
            res ={status:200,data:countmoneyData};

            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/ibizorderdetails`,data,isloading);
            let countmoney:CountMoneyLogic = new CountMoneyLogic({context:JSON.parse(JSON.stringify(context)),data:JSON.parse(JSON.stringify(res)).data});
            let countmoneyData:any = await countmoney.onExecute(context,res.data,isloading?true:false);
            res ={status:200,data:countmoneyData};

        return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && context.ibizorderdetail){
            let res:any = await Http.getInstance().get(`/ibizorders/${context.ibizorder}/ibizorderdetails/${context.ibizorderdetail}`,{},isloading);
                let getunitandprice:GetUnitAndPriceLogic = new GetUnitAndPriceLogic({context:JSON.parse(JSON.stringify(context)),data:JSON.parse(JSON.stringify(res)).data});
            let getunitandpriceData:any = await getunitandprice.onExecute(context,res.data,isloading?true:false);
            res ={status:200,data:getunitandpriceData};

            return res;
        }
            let res:any = await Http.getInstance().get(`/ibizorderdetails/${context.ibizorderdetail}`,{},isloading);
                let getunitandprice:GetUnitAndPriceLogic = new GetUnitAndPriceLogic({context:JSON.parse(JSON.stringify(context)),data:JSON.parse(JSON.stringify(res)).data});
            let getunitandpriceData:any = await getunitandprice.onExecute(context,res.data,isloading?true:false);
            res ={status:200,data:getunitandpriceData};

            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && true){
            let res:any = await Http.getInstance().get(`/ibizorders/${context.ibizorder}/ibizorderdetails/getdraft`,{},isloading);
            res.data.ibizorderdetail = data.ibizorderdetail;
            
            return res;
        }
        let res:any = await  Http.getInstance().get(`/ibizorderdetails/getdraft`,{},isloading);
        res.data.ibizorderdetail = data.ibizorderdetail;
        
        return res;
    }

    /**
     * GetUnitAndPrice接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async GetUnitAndPrice(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let appLogic:GetUnitAndPriceLogic = new GetUnitAndPriceLogic({context:JSON.parse(JSON.stringify(context)),data:JSON.parse(JSON.stringify(data))});
        data = await appLogic.onExecute(context,data,isloading?true:false);
        let res:any ={status:200,data:data};
        return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && context.ibizorderdetail){
            let res:any = Http.getInstance().delete(`/ibizorders/${context.ibizorder}/ibizorderdetails/${context.ibizorderdetail}`,{},isloading);
            return res;
        }
            let res:any = Http.getInstance().delete(`/ibizorderdetails/${context.ibizorderdetail}`,{},isloading);
            return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && context.ibizorderdetail){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().post(`/ibizorders/${context.ibizorder}/ibizorderdetails/${context.ibizorderdetail}/save`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/ibizorderdetails/${context.ibizorderdetail}/save`,data,isloading);
            
            return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && context.ibizorderdetail){
            let masterData:any = {};
            Object.assign(data,masterData);
            let res:any = await Http.getInstance().put(`/ibizorders/${context.ibizorder}/ibizorderdetails/${context.ibizorderdetail}`,data,isloading);
            
            return res;
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/ibizorderdetails/${context.ibizorderdetail}`,data,isloading);
            
            return res;
    }

    /**
     * FetchCSMXDY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchCSMXDY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/ibizorders/${context.ibizorder}/ibizorderdetails/fetchcsmxdy`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorderdetails/fetchcsmxdy`,tempData,isloading);
        return res;
    }

    /**
     * searchCSMXDY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async searchCSMXDY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/ibizorders/${context.ibizorder}/ibizorderdetails/searchcsmxdy`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorderdetails/searchcsmxdy`,tempData,isloading);
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/ibizorders/${context.ibizorder}/ibizorderdetails/fetchdefault`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorderdetails/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/ibizorders/${context.ibizorder}/ibizorderdetails/searchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorderdetails/searchdefault`,tempData,isloading);
    }

    /**
     * FetchLOGIC_0007接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchLOGIC_0007(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/ibizorders/${context.ibizorder}/ibizorderdetails/fetchlogic_0007`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorderdetails/fetchlogic_0007`,tempData,isloading);
        return res;
    }

    /**
     * searchLOGIC_0007接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async searchLOGIC_0007(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/ibizorders/${context.ibizorder}/ibizorderdetails/searchlogic_0007`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorderdetails/searchlogic_0007`,tempData,isloading);
    }

    /**
     * FetchX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            let res:any = Http.getInstance().get(`/ibizorders/${context.ibizorder}/ibizorderdetails/fetchx`,tempData,isloading);
            return res;
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorderdetails/fetchx`,tempData,isloading);
        return res;
    }

    /**
     * searchX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async searchX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return await Http.getInstance().post(`/ibizorders/${context.ibizorder}/ibizorderdetails/searchx`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorderdetails/searchx`,tempData,isloading);
    }

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.ibizorder && context.ibizorderdetail){
            let res:any = Http.getInstance().get(`/ibizorders/${context.ibizorder}/ibizorderdetails/${context.ibizorderdetail}/select`,{},isloading);
            
            return res;
        }
            let res:any = Http.getInstance().get(`/ibizorderdetails/${context.ibizorderdetail}/select`,{},isloading);
            
            return res;
    }
}