import { Http,Util } from '@/utils';
import CustomViewDestroyUILogicBase from './custom-view-destroy-ui-logic-base';

/**
 * 自定义表格视图销毁
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic.ts.ftl 生成
 * @export
 * @class CustomViewDestroyUILogic
 */
export default class CustomViewDestroyUILogic extends CustomViewDestroyUILogicBase {

    /**
     * 自定义表格视图销毁 逻辑实例对象
     *
     * @private
     * @static
     * @type {CustomViewDestroyUILogic}
     * @memberof CustomViewDestroyUILogic
     */
    private static instance: CustomViewDestroyUILogic;

    /**
     * 获取 自定义表格视图销毁 逻辑实例对象
     *
     * @static
     * @return {*}  {CustomViewDestroyUILogic}
     * @memberof CustomViewDestroyUILogic
     */
    static getInstance(): CustomViewDestroyUILogic {
        if (!this.instance) {
            this.instance = new CustomViewDestroyUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  CustomViewDestroyUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  CustomViewDestroyUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}