import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IBIZOrderService from '@/service/ibizorder/ibizorder-service';
import PieModel from './pie-chart-model';


/**
 * Pie 部件服务对象
 *
 * @export
 * @class PieService
 */
export default class PieService extends ControlService {

    /**
     * 订单服务对象
     *
     * @type {IBIZOrderService}
     * @memberof PieService
     */
    public appEntityService: IBIZOrderService = new IBIZOrderService({ $store: this.getStore() });

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof PieService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of PieService.
     * 
     * @param {*} [opts={}]
     * @memberof PieService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new PieModel();
    }

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof PieService
     */
    @Errorlog
    public search(action: string,context: any = {}, data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data,true);
        return new Promise((resolve: any, reject: any) => {
            const _appEntityService: any = this.appEntityService;
            let result: Promise<any>;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            }else{
                result =_appEntityService.FetchDefault(Context,Data, isloading);
            }
            result.then((response) => {
                resolve(response);
            }).catch(response => {
                reject(response);
            });      
        });
    }
}