package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZOrderDetail;
import cn.ibizlab.core.sample.service.IIBIZOrderDetailService;
import cn.ibizlab.core.sample.filter.IBIZOrderDetailSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单明细" })
@RestController("DemoAPI-ibizorderdetail")
@RequestMapping("")
public class IBIZOrderDetailResource {

    @Autowired
    public IIBIZOrderDetailService ibizorderdetailService;

    @Autowired
    @Lazy
    public IBIZOrderDetailMapping ibizorderdetailMapping;

    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildto),'DemoSys-IBIZOrderDetail-Create')")
    @ApiOperation(value = "新建订单明细", tags = {"订单明细" },  notes = "新建订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails")
    public ResponseEntity<IBIZOrderDetailDTO> create(@Validated @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
		ibizorderdetailService.create(domain);
        IBIZOrderDetailDTO dto = ibizorderdetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildtos),'DemoSys-IBIZOrderDetail-Create')")
    @ApiOperation(value = "批量新建订单明细", tags = {"订单明细" },  notes = "批量新建订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZOrderDetailDTO> ibizorderdetaildtos) {
        ibizorderdetailService.createBatch(ibizorderdetailMapping.toDomain(ibizorderdetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizorderdetail" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizorderdetailService.get(#ibizorderdetail_id),'DemoSys-IBIZOrderDetail-Update')")
    @ApiOperation(value = "更新订单明细", tags = {"订单明细" },  notes = "更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorderdetails/{ibizorderdetail_id}")
    public ResponseEntity<IBIZOrderDetailDTO> update(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
		IBIZOrderDetail domain  = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain .setIbizorderdetailid(ibizorderdetail_id);
		ibizorderdetailService.update(domain );
		IBIZOrderDetailDTO dto = ibizorderdetailMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailService.getIbizorderdetailByEntities(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildtos)),'DemoSys-IBIZOrderDetail-Update')")
    @ApiOperation(value = "批量更新订单明细", tags = {"订单明细" },  notes = "批量更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorderdetails/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZOrderDetailDTO> ibizorderdetaildtos) {
        ibizorderdetailService.updateBatch(ibizorderdetailMapping.toDomain(ibizorderdetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailService.get(#ibizorderdetail_id),'DemoSys-IBIZOrderDetail-Remove')")
    @ApiOperation(value = "删除订单明细", tags = {"订单明细" },  notes = "删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorderdetails/{ibizorderdetail_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailService.remove(ibizorderdetail_id));
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailService.getIbizorderdetailByIds(#ids),'DemoSys-IBIZOrderDetail-Remove')")
    @ApiOperation(value = "批量删除订单明细", tags = {"订单明细" },  notes = "批量删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorderdetails/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizorderdetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(returnObject.body),'DemoSys-IBIZOrderDetail-Get')")
    @ApiOperation(value = "获取订单明细", tags = {"订单明细" },  notes = "获取订单明细")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorderdetails/{ibizorderdetail_id}")
    public ResponseEntity<IBIZOrderDetailDTO> get(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id) {
        IBIZOrderDetail domain = ibizorderdetailService.get(ibizorderdetail_id);
        IBIZOrderDetailDTO dto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取订单明细草稿", tags = {"订单明细" },  notes = "获取订单明细草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorderdetails/getdraft")
    public ResponseEntity<IBIZOrderDetailDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailMapping.toDto(ibizorderdetailService.getDraft(new IBIZOrderDetail())));
    }

    @ApiOperation(value = "检查订单明细", tags = {"订单明细" },  notes = "检查订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailService.checkKey(ibizorderdetailMapping.toDomain(ibizorderdetaildto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-CountMoney-all')")
    @ApiOperation(value = "统计金额", tags = {"订单明细" },  notes = "统计金额")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/{ibizorderdetail_id}/countmoney")
    public ResponseEntity<IBIZOrderDetailDTO> countMoney(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.countMoney(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-GetUnitAndPrice-all')")
    @ApiOperation(value = "", tags = {"订单明细" },  notes = "")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorderdetails/{ibizorderdetail_id}/getunitandprice")
    public ResponseEntity<IBIZOrderDetailDTO> getUnitAndPrice(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.getUnitAndPrice(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildto),'DemoSys-IBIZOrderDetail-Save')")
    @ApiOperation(value = "保存订单明细", tags = {"订单明细" },  notes = "保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailService.save(ibizorderdetailMapping.toDomain(ibizorderdetaildto)));
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildtos),'DemoSys-IBIZOrderDetail-Save')")
    @ApiOperation(value = "批量保存订单明细", tags = {"订单明细" },  notes = "批量保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZOrderDetailDTO> ibizorderdetaildtos) {
        ibizorderdetailService.saveBatch(ibizorderdetailMapping.toDomain(ibizorderdetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchCSMXDY-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "获取测试明细打印", tags = {"订单明细" } ,notes = "获取测试明细打印")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorderdetails/fetchcsmxdy")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchCSMXDY(IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchCSMXDY(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchCSMXDY-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "查询测试明细打印", tags = {"订单明细" } ,notes = "查询测试明细打印")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/searchcsmxdy")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchCSMXDY(@RequestBody IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchCSMXDY(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"订单明细" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorderdetails/fetchdefault")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchDefault(IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchDefault(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"订单明细" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/searchdefault")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchDefault(@RequestBody IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchLOGIC_0007-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "获取查询订单明细中产品数量", tags = {"订单明细" } ,notes = "获取查询订单明细中产品数量")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorderdetails/fetchlogic_0007")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchLOGIC_0007(IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchLOGIC_0007(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchLOGIC_0007-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "查询查询订单明细中产品数量", tags = {"订单明细" } ,notes = "查询查询订单明细中产品数量")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/searchlogic_0007")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchLOGIC_0007(@RequestBody IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchLOGIC_0007(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchX-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "获取x", tags = {"订单明细" } ,notes = "获取x")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorderdetails/fetchx")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchX(IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchX(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchX-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "查询x", tags = {"订单明细" } ,notes = "查询x")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/searchx")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchX(@RequestBody IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchX(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildto),'DemoSys-IBIZOrderDetail-Create')")
    @ApiOperation(value = "根据订单建立订单明细", tags = {"订单明细" },  notes = "根据订单建立订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/{ibizorder_id}/ibizorderdetails")
    public ResponseEntity<IBIZOrderDetailDTO> createByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderid(ibizorder_id);
		ibizorderdetailService.create(domain);
        IBIZOrderDetailDTO dto = ibizorderdetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildtos),'DemoSys-IBIZOrderDetail-Create')")
    @ApiOperation(value = "根据订单批量建立订单明细", tags = {"订单明细" },  notes = "根据订单批量建立订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/batch")
    public ResponseEntity<Boolean> createBatchByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody List<IBIZOrderDetailDTO> ibizorderdetaildtos) {
        List<IBIZOrderDetail> domainlist=ibizorderdetailMapping.toDomain(ibizorderdetaildtos);
        for(IBIZOrderDetail domain:domainlist){
            domain.setIbizorderid(ibizorder_id);
        }
        ibizorderdetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizorderdetail" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizorderdetailService.get(#ibizorderdetail_id),'DemoSys-IBIZOrderDetail-Update')")
    @ApiOperation(value = "根据订单更新订单明细", tags = {"订单明细" },  notes = "根据订单更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/{ibizorderdetail_id}")
    public ResponseEntity<IBIZOrderDetailDTO> updateByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderid(ibizorder_id);
        domain.setIbizorderdetailid(ibizorderdetail_id);
		ibizorderdetailService.update(domain);
        IBIZOrderDetailDTO dto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailService.getIbizorderdetailByEntities(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildtos)),'DemoSys-IBIZOrderDetail-Update')")
    @ApiOperation(value = "根据订单批量更新订单明细", tags = {"订单明细" },  notes = "根据订单批量更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/batch")
    public ResponseEntity<Boolean> updateBatchByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody List<IBIZOrderDetailDTO> ibizorderdetaildtos) {
        List<IBIZOrderDetail> domainlist=ibizorderdetailMapping.toDomain(ibizorderdetaildtos);
        for(IBIZOrderDetail domain:domainlist){
            domain.setIbizorderid(ibizorder_id);
        }
        ibizorderdetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailService.get(#ibizorderdetail_id),'DemoSys-IBIZOrderDetail-Remove')")
    @ApiOperation(value = "根据订单删除订单明细", tags = {"订单明细" },  notes = "根据订单删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/{ibizorderdetail_id}")
    public ResponseEntity<Boolean> removeByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @PathVariable("ibizorderdetail_id") String ibizorderdetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailService.remove(ibizorderdetail_id));
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailService.getIbizorderdetailByIds(#ids),'DemoSys-IBIZOrderDetail-Remove')")
    @ApiOperation(value = "根据订单批量删除订单明细", tags = {"订单明细" },  notes = "根据订单批量删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/batch")
    public ResponseEntity<Boolean> removeBatchByIBIZOrder(@RequestBody List<String> ids) {
        ibizorderdetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(returnObject.body),'DemoSys-IBIZOrderDetail-Get')")
    @ApiOperation(value = "根据订单获取订单明细", tags = {"订单明细" },  notes = "根据订单获取订单明细")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/{ibizorderdetail_id}")
    public ResponseEntity<IBIZOrderDetailDTO> getByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @PathVariable("ibizorderdetail_id") String ibizorderdetail_id) {
        IBIZOrderDetail domain = ibizorderdetailService.get(ibizorderdetail_id);
        IBIZOrderDetailDTO dto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据订单获取订单明细草稿", tags = {"订单明细" },  notes = "根据订单获取订单明细草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/getdraft")
    public ResponseEntity<IBIZOrderDetailDTO> getDraftByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id) {
        IBIZOrderDetail domain = new IBIZOrderDetail();
        domain.setIbizorderid(ibizorder_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailMapping.toDto(ibizorderdetailService.getDraft(domain)));
    }

    @ApiOperation(value = "根据订单检查订单明细", tags = {"订单明细" },  notes = "根据订单检查订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailService.checkKey(ibizorderdetailMapping.toDomain(ibizorderdetaildto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-CountMoney-all')")
    @ApiOperation(value = "根据订单订单明细", tags = {"订单明细" },  notes = "根据订单订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/{ibizorderdetail_id}/countmoney")
    public ResponseEntity<IBIZOrderDetailDTO> countMoneyByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderdetailService.countMoney(domain) ;
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-GetUnitAndPrice-all')")
    @ApiOperation(value = "根据订单订单明细", tags = {"订单明细" },  notes = "根据订单订单明细")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/{ibizorderdetail_id}/getunitandprice")
    public ResponseEntity<IBIZOrderDetailDTO> getUnitAndPriceByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderid(ibizorder_id);
        domain = ibizorderdetailService.getUnitAndPrice(domain) ;
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }
    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildto),'DemoSys-IBIZOrderDetail-Save')")
    @ApiOperation(value = "根据订单保存订单明细", tags = {"订单明细" },  notes = "根据订单保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/save")
    public ResponseEntity<Boolean> saveByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderid(ibizorder_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailService.save(domain));
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildtos),'DemoSys-IBIZOrderDetail-Save')")
    @ApiOperation(value = "根据订单批量保存订单明细", tags = {"订单明细" },  notes = "根据订单批量保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorders/{ibizorder_id}/ibizorderdetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody List<IBIZOrderDetailDTO> ibizorderdetaildtos) {
        List<IBIZOrderDetail> domainlist=ibizorderdetailMapping.toDomain(ibizorderdetaildtos);
        for(IBIZOrderDetail domain:domainlist){
             domain.setIbizorderid(ibizorder_id);
        }
        ibizorderdetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchCSMXDY-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "根据订单获取测试明细打印", tags = {"订单明细" } ,notes = "根据订单获取测试明细打印")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/{ibizorder_id}/ibizorderdetails/fetchcsmxdy")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchIBIZOrderDetailCSMXDYByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id,IBIZOrderDetailSearchContext context) {
        context.setN_ibizorderid_eq(ibizorder_id);
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchCSMXDY(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchCSMXDY-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "根据订单查询测试明细打印", tags = {"订单明细" } ,notes = "根据订单查询测试明细打印")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/{ibizorder_id}/ibizorderdetails/searchcsmxdy")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchIBIZOrderDetailCSMXDYByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDetailSearchContext context) {
        context.setN_ibizorderid_eq(ibizorder_id);
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchCSMXDY(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "根据订单获取DEFAULT", tags = {"订单明细" } ,notes = "根据订单获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/{ibizorder_id}/ibizorderdetails/fetchdefault")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchIBIZOrderDetailDefaultByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id,IBIZOrderDetailSearchContext context) {
        context.setN_ibizorderid_eq(ibizorder_id);
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchDefault(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "根据订单查询DEFAULT", tags = {"订单明细" } ,notes = "根据订单查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/{ibizorder_id}/ibizorderdetails/searchdefault")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchIBIZOrderDetailDefaultByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDetailSearchContext context) {
        context.setN_ibizorderid_eq(ibizorder_id);
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchLOGIC_0007-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "根据订单获取查询订单明细中产品数量", tags = {"订单明细" } ,notes = "根据订单获取查询订单明细中产品数量")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/{ibizorder_id}/ibizorderdetails/fetchlogic_0007")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchIBIZOrderDetailLOGIC_0007ByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id,IBIZOrderDetailSearchContext context) {
        context.setN_ibizorderid_eq(ibizorder_id);
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchLOGIC_0007(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchLOGIC_0007-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "根据订单查询查询订单明细中产品数量", tags = {"订单明细" } ,notes = "根据订单查询查询订单明细中产品数量")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/{ibizorder_id}/ibizorderdetails/searchlogic_0007")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchIBIZOrderDetailLOGIC_0007ByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDetailSearchContext context) {
        context.setN_ibizorderid_eq(ibizorder_id);
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchLOGIC_0007(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchX-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "根据订单获取x", tags = {"订单明细" } ,notes = "根据订单获取x")
    @RequestMapping(method= RequestMethod.GET , value="/ibizorders/{ibizorder_id}/ibizorderdetails/fetchx")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchIBIZOrderDetailXByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id,IBIZOrderDetailSearchContext context) {
        context.setN_ibizorderid_eq(ibizorder_id);
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchX(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchX-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "根据订单查询x", tags = {"订单明细" } ,notes = "根据订单查询x")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorders/{ibizorder_id}/ibizorderdetails/searchx")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchIBIZOrderDetailXByIBIZOrder(@PathVariable("ibizorder_id") String ibizorder_id, @RequestBody IBIZOrderDetailSearchContext context) {
        context.setN_ibizorderid_eq(ibizorder_id);
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchX(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

