/**
 * ExporAndImportGrid 部件模型
 *
 * @export
 * @class ExporAndImportGridModel
 */
export default class ExporAndImportGridModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof ExporAndImportGridGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof ExporAndImportGridGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'subtext',
          prop: 'subtext',
          dataType: 'TEXT',
        },
        {
          name: 'press',
          prop: 'press',
          dataType: 'TEXT',
        },
        {
          name: 'tag',
          prop: 'tag',
          dataType: 'LONGTEXT',
        },
        {
          name: 'ibizbookid',
          prop: 'ibizbookid',
          dataType: 'GUID',
        },
        {
          name: 'sailstate',
          prop: 'sailstate',
          dataType: 'TEXT',
        },
        {
          name: 'type',
          prop: 'type',
          dataType: 'TEXT',
        },
        {
          name: 'srfmstag',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizbookname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizbookid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizbookid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'author',
          prop: 'author',
          dataType: 'TEXT',
        },
        {
          name: 'ibizbookname',
          prop: 'ibizbookname',
          dataType: 'TEXT',
        },
        {
          name: 'price',
          prop: 'price',
          dataType: 'FLOAT',
        },
        {
          name: 'booknumber',
          prop: 'booknumber',
          dataType: 'INT',
        },
        {
          name: 'borrowway',
          prop: 'borrowway',
          dataType: 'SSCODELIST',
        },
        {
          name: 'ibizbook',
          prop: 'ibizbookid',
        },
        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}