package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZSample0021DTO]
 */
@Data
public class IBIZSample0021DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBIZSAMPLE0021ID]
     *
     */
    @JSONField(name = "ibizsample0021id")
    @JsonProperty("ibizsample0021id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizsample0021id;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [IBIZSAMPLE0021NAME]
     *
     */
    @JSONField(name = "ibizsample0021name")
    @JsonProperty("ibizsample0021name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizsample0021name;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [ORDERSTATE]
     *
     */
    @JSONField(name = "orderstate")
    @JsonProperty("orderstate")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String orderstate;

    /**
     * 属性 [ORDERTIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "ordertime" , format="yyyy-MM-dd")
    @JsonProperty("ordertime")
    private Timestamp ordertime;

    /**
     * 属性 [MEMO]
     *
     */
    @JSONField(name = "memo")
    @JsonProperty("memo")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    private String memo;

    /**
     * 属性 [CURORGID]
     *
     */
    @JSONField(name = "curorgid")
    @JsonProperty("curorgid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String curorgid;

    /**
     * 属性 [CURDEPTID]
     *
     */
    @JSONField(name = "curdeptid")
    @JsonProperty("curdeptid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String curdeptid;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Double amount;


    /**
     * 设置 [IBIZSAMPLE0021NAME]
     */
    public void setIbizsample0021name(String  ibizsample0021name){
        this.ibizsample0021name = ibizsample0021name ;
        this.modify("ibizsample0021name",ibizsample0021name);
    }

    /**
     * 设置 [ORDERSTATE]
     */
    public void setOrderstate(String  orderstate){
        this.orderstate = orderstate ;
        this.modify("orderstate",orderstate);
    }

    /**
     * 设置 [ORDERTIME]
     */
    public void setOrdertime(Timestamp  ordertime){
        this.ordertime = ordertime ;
        this.modify("ordertime",ordertime);
    }

    /**
     * 设置 [MEMO]
     */
    public void setMemo(String  memo){
        this.memo = memo ;
        this.modify("memo",memo);
    }

    /**
     * 设置 [CURORGID]
     */
    public void setCurorgid(String  curorgid){
        this.curorgid = curorgid ;
        this.modify("curorgid",curorgid);
    }

    /**
     * 设置 [CURDEPTID]
     */
    public void setCurdeptid(String  curdeptid){
        this.curdeptid = curdeptid ;
        this.modify("curdeptid",curdeptid);
    }

    /**
     * 设置 [AMOUNT]
     */
    public void setAmount(Double  amount){
        this.amount = amount ;
        this.modify("amount",amount);
    }


}


