// 基于 @CONTROL/日历部件/SERVICE.ts.ftl 生成
import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IBIZBOOKService from '@/service/ibizbook/ibizbook-service';
import IBIZBOOKMONTHModel from './ibizbookmonth-calendar-model';


/**
 * IBIZBOOKMONTH 部件服务对象
 *
 * @export
 * @class IBIZBOOKMONTHService
 */
export default class IBIZBOOKMONTHService extends ControlService {

    /**
     * 图书服务对象
     *
     * @type {IBIZBOOKService}
     * @memberof IBIZBOOKMONTHService
     */
    public appEntityService: IBIZBOOKService = new IBIZBOOKService();

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof IBIZBOOKMONTHService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of IBIZBOOKMONTHService.
     * 
     * @param {*} [opts={}]
     * @memberof IBIZBOOKMONTHService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new IBIZBOOKMONTHModel();
    }


    /**
     * 事件配置集合
     *
     * @public
     * @type {any[]}
     * @memberof IBIZBOOKMONTH
     */
    public eventsConfig: any[] = [
        {
          itemName : '借书日记',
          itemType : 'item1',
          color : 'rgba(235, 21, 21, 1)',
          textColor : 'rgba(13, 190, 34, 1)',
        },
    ];

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZBOOKMONTHService
     */
    @Errorlog
    public search(action: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let _this = this;
        return new Promise((resolve: any, reject: any) => {
            let promises:any = [];
            let tempRequest:any;
            tempRequest = this.handleRequestData(action,context,data,true,"item1");
            promises.push(this.appEntityService.FetchDefault(tempRequest.context, tempRequest.data, isloading));
            Promise.all(promises).then((resArray: any) => {
                let _data:any = [];
                resArray.forEach((response:any,resIndex:number) => {
                    if (!response || response.status !== 200) {
                        return;
                    }
                    let _response: any = JSON.parse(JSON.stringify(response));
                    _response.data.forEach((item:any,index:number) =>{
                        _response.data[index].color = _this.eventsConfig[resIndex].color;
                        _response.data[index].textColor = _this.eventsConfig[resIndex].textColor;
                        _response.data[index].itemType = _this.eventsConfig[resIndex].itemType;
                    });
                    ;
                    _this.handleResponse(action, _response,false,_this.eventsConfig[resIndex].itemType);
                    _data.push(..._response.data);
                });
                // 排序
                _data.sort((a: any, b: any) => {
                    if (a.start && b.start) {
                        let dateA = new Date(Date.parse(a.start.replace(/-/g, "/")));
                        let dateB = new Date(Date.parse(b.start.replace(/-/g, "/")));
                        return dateA > dateB ? 1 : -1 ;
                    }
                    return 0;
                });
                let result = {status: 200, data: _data};
                resolve(result);
            }).catch((response: any) => {
                reject(response);
            });  
        });
    }

    /**
     * 修改数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZBOOKMONTHService
     */
    @Errorlog
    public update(itemType: string, context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        return new Promise((resolve: any, reject: any) => {
            let result: any;
            let tempRequest:any;
            switch(itemType) {
                case "item1":
                    tempRequest = this.handleRequestData("",context,data,false,"item1");
                    result = this.appEntityService.Update(tempRequest.context, tempRequest.data, isloading);
                    break;
            }
            if(result){
                result.then((response: any) => {
                    this.handleResponse("", response);
                    resolve(response);
                }).catch((response: any) => {
                    reject(response);
                });
            }else{
              reject("没有匹配的实体服务");
            }
        });
    }

    /**
     * 处理request请求数据
     * 
     * @param action 行为 
     * @param data 数据
     * @memberof ControlService
     */
    public handleRequestData(action: string,context:any ={},data: any = {},isMerge:boolean = false,itemType:string=""){
        let model: any = this.getMode();
        model.itemType = itemType;
        return super.handleRequestData(action,context,data,isMerge);
    }

    /**
     * 处理response返回数据
     *
     * @param {string} action
     * @param {*} response
     * @memberof ControlService
     */
    public async handleResponse(action: string, response: any,isCreate:boolean = false,itemType:string=""){
        let model: any = this.getMode();
        model.itemType = itemType;
        super.handleResponse(action,response,isCreate);
    }

}