import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';
import { globalRoutes, indexRoutes} from '@/router'
// 基于 @VIEW/应用首页视图/ROUTER.ts.ftl 生成
Vue.use(Router);

const router = new Router({
    routes: [
        {
            path: '/appindexview2/:appindexview2?',
            beforeEnter: (to: any, from: any, next: any) => {
                const routerParamsName = 'appindexview2';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    Object.assign(params, qs.parse(to.params[routerParamsName], { delimiter: ';' }));
                }
                const url: string = '/appdata';
                const auth: Promise<any> = AuthGuard.getInstance().authGuard(url, params, router);
                auth.then(() => {
                    next();
                }).catch(() => {
                    next();
                });
            },
            meta: {  
                caption: 'app.views.appindexview2.caption',
                info:'',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'appindexview2', parameterName: 'appindexview2' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/sample/app-index-view2/app-index-view2.vue'),
            children: [
                {
                    path: 'ibizbooks/:ibizbook?/usr2treeview/:usr2treeview?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr2treeview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr2treeview', parameterName: 'usr2treeview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr2-tree-view/ibizbookusr2-tree-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/stabexpview/:stabexpview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.stabexpview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'stabexpview', parameterName: 'stabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-stab-exp-view/ibizsample0003-stab-exp-view.vue'),
                },
                {
                    path: 'ibizuniproducts/:ibizuniproduct?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.ibizuniproduct.views.gridview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizuniproduct-grid-view9/ibizuniproduct-grid-view9.vue'),
                },
                {
                    path: 'ibizhardwares/:ibizhardware?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.ibizhardware.views.gridview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizhardware-grid-view9/ibizhardware-grid-view9.vue'),
                },
                {
                    path: 'ibizsoftwaresuits/:ibizsoftwaresuit?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.ibizsoftwaresuit.views.gridview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizsoftwaresuits', parameterName: 'ibizsoftwaresuit' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsoftware-suit-grid-view9/ibizsoftware-suit-grid-view9.vue'),
                },
                {
                    path: 'ibizuniproducts/:ibizuniproduct?/indexpickupview/:indexpickupview?',
                    meta: {
                        caption: 'entities.ibizuniproduct.views.indexpickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                            { pathName: 'indexpickupview', parameterName: 'indexpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizuniproduct-index-pickup-view/ibizuniproduct-index-pickup-view.vue'),
                },
                {
                    path: 'ibizhardwares/:ibizhardware?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizhardware.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizhardware-edit-view/ibizhardware-edit-view.vue'),
                },
                {
                    path: 'ibizsoftwaresuits/:ibizsoftwaresuit?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizsoftwaresuit.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizsoftwaresuits', parameterName: 'ibizsoftwaresuit' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsoftware-suit-edit-view/ibizsoftware-suit-edit-view.vue'),
                },
                {
                    path: 'ibizhardwares/:ibizhardware?/indexpickupview/:indexpickupview?',
                    meta: {
                        caption: 'entities.ibizhardware.views.indexpickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                            { pathName: 'indexpickupview', parameterName: 'indexpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizhardware-index-pickup-view/ibizhardware-index-pickup-view.vue'),
                },
                {
                    path: 'ibizcpus/:ibizcpu?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizcpu.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizcpus', parameterName: 'ibizcpu' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizcpuedit-view/ibizcpuedit-view.vue'),
                },
                {
                    path: 'ibizstorages/:ibizstorage?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizstorage.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizstorages', parameterName: 'ibizstorage' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizstorage-edit-view/ibizstorage-edit-view.vue'),
                },
                {
                    path: 'ibizuniproducts/:ibizuniproduct?/indexpickupdataview/:indexpickupdataview?',
                    meta: {
                        caption: 'entities.ibizuniproduct.views.indexpickupdataview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                            { pathName: 'indexpickupdataview', parameterName: 'indexpickupdataview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizuniproduct-index-pickup-data-view/ibizuniproduct-index-pickup-data-view.vue'),
                },
                {
                    path: 'ibizhardwares/:ibizhardware?/indexpickupdataview/:indexpickupdataview?',
                    meta: {
                        caption: 'entities.ibizhardware.views.indexpickupdataview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview2', parameterName: 'appindexview2' },
                            { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                            { pathName: 'indexpickupdataview', parameterName: 'indexpickupdataview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizhardware-index-pickup-data-view/ibizhardware-index-pickup-data-view.vue'),
                },
            {
                path: 'ibizuniproducts/:ibizuniproduct?/redirectview/:redirectview?',
                meta: {
                    caption: 'entities.ibizuniproduct.views.redirectview.caption',
                    info:'',
                    viewType: 'REDIRECTVIEW',
                    parameters: [
                        { pathName: 'appindexview2', parameterName: 'appindexview2' },
                        { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                        { pathName: 'redirectview', parameterName: 'redirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/sample/ibizuniproduct-redirect-view/ibizuniproduct-redirect-view.vue'),
            },
            {
                path: 'ibizbooks/:ibizbook?/redirectview/:redirectview?',
                meta: {
                    caption: 'entities.ibizbook.views.redirectview.caption',
                    info:'',
                    viewType: 'REDIRECTVIEW',
                    parameters: [
                        { pathName: 'appindexview2', parameterName: 'appindexview2' },
                        { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                        { pathName: 'redirectview', parameterName: 'redirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/sample/ibizbookredirect-view/ibizbookredirect-view.vue'),
            },
            {
                path: 'ibizorders/:ibizorder?/redirectview/:redirectview?',
                meta: {
                    caption: 'entities.ibizorder.views.redirectview.caption',
                    info:'',
                    viewType: 'REDIRECTVIEW',
                    parameters: [
                        { pathName: 'appindexview2', parameterName: 'appindexview2' },
                        { pathName: 'ibizorders', parameterName: 'ibizorder' },
                        { pathName: 'redirectview', parameterName: 'redirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/sample/ibizorder-redirect-view/ibizorder-redirect-view.vue'),
            },
            {
                path: 'appwfdataredirectview/:appwfdataredirectview?',
                meta: {
                    caption: 'app.views.appwfredirectview.caption',
                    info:'',
                    viewType: 'REDIRECTVIEW',
                    parameters: [
                        { pathName: 'appindexview2', parameterName: 'appindexview2' },
                        { pathName: 'appwfredirectview', parameterName: 'appwfredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/ungroup/app-wfredirect-view/app-wfredirect-view.vue'),
            },
            ...indexRoutes,
            ],
        },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/sgridview/:sgridview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.sgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'sgridview', parameterName: 'sgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-sgrid-view/ibizuniproduct-sgrid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/treeview/:treeview?',
        meta: {
            caption: 'entities.ibizbook.views.treeview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'treeview', parameterName: 'treeview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbooktree-view/ibizbooktree-view.vue'),
    },
    {
        path: '/ibizhardwares/:ibizhardware?/indexpickupdataview/:indexpickupdataview?',
        meta: {
            caption: 'entities.ibizhardware.views.indexpickupdataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                { pathName: 'indexpickupdataview', parameterName: 'indexpickupdataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizhardware-index-pickup-data-view/ibizhardware-index-pickup-data-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/internalfuncgridview/:internalfuncgridview?',
        meta: {
            caption: 'entities.ibizbook.views.internalfuncgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'internalfuncgridview', parameterName: 'internalfuncgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookinternal-func-grid-view/ibizbookinternal-func-grid-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.ibizsample0002.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0002-pickup-view/ibizsample0002-pickup-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/gridloadcustomview/:gridloadcustomview?',
        meta: {
            caption: 'entities.ibizbook.views.gridloadcustomview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'gridloadcustomview', parameterName: 'gridloadcustomview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookgrid-load-custom-view/ibizbookgrid-load-custom-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/haspanelkanbanview/:haspanelkanbanview?',
        meta: {
            caption: 'entities.ibizbook.views.haspanelkanbanview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'haspanelkanbanview', parameterName: 'haspanelkanbanview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookhas-panel-kan-ban-view/ibizbookhas-panel-kan-ban-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/testcldataview/:testcldataview?',
        meta: {
            caption: 'entities.ibizbook.views.testcldataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'testcldataview', parameterName: 'testcldataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbooktest-cldata-view/ibizbooktest-cldata-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.ibizcustomer.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-pickup-grid-view/ibizcustomer-pickup-grid-view.vue'),
    },
    {
        path: '/ibizappviews/:ibizappview?/editview/:editview?',
        meta: {
            caption: 'entities.ibizappview.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappviews', parameterName: 'ibizappview' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappviewedit-view/ibizappviewedit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr6gridview_layout/:usr6gridview_layout?',
        meta: {
            caption: 'entities.ibizbook.views.usr6gridview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr6gridview_layout', parameterName: 'usr6gridview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr6-grid-view-layout/ibizbookusr6-grid-view-layout.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/f10editview/:f10editview?',
        meta: {
            caption: 'entities.ibizorder.views.f10editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'f10editview', parameterName: 'f10editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-f10-edit-view/ibizorder-f10-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr7gridview/:usr7gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr7gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr7gridview', parameterName: 'usr7gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr7-grid-view/ibizbookusr7-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/usr5editview/:usr5editview?',
        meta: {
            caption: 'entities.ibizorder.views.usr5editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'usr5editview', parameterName: 'usr5editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-usr5-edit-view/ibizorder-usr5-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/dashboardview/:dashboardview?',
        meta: {
            caption: 'entities.ibizbook.views.dashboardview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'dashboardview', parameterName: 'dashboardview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookdashboard-view/ibizbookdashboard-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr4dataview/:usr4dataview?',
        meta: {
            caption: 'entities.ibizbook.views.usr4dataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr4dataview', parameterName: 'usr4dataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr4-data-view/ibizbookusr4-data-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/editview/:editview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-edit-view/ibizuniproduct-edit-view.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/wfdynaactionview/:wfdynaactionview?',
        meta: {
            caption: 'entities.ibizsample0021.views.wfdynaactionview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'wfdynaactionview', parameterName: 'wfdynaactionview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-wfdyna-action-view/ibizsample0021-wfdyna-action-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr3customview/:usr3customview?',
        meta: {
            caption: 'entities.ibizbook.views.usr3customview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr3customview', parameterName: 'usr3customview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr3-custom-view/ibizbookusr3-custom-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/editview4/:editview4?',
        meta: {
            caption: 'entities.ibizbook.views.editview4.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'editview4', parameterName: 'editview4' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookedit-view4/ibizbookedit-view4.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/testcltreeview/:testcltreeview?',
        meta: {
            caption: 'entities.ibizbook.views.testcltreeview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'testcltreeview', parameterName: 'testcltreeview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbooktest-cltree-view/ibizbooktest-cltree-view.vue'),
    },
    {
        path: '/ibizsoftwaresuits/:ibizsoftwaresuit?/sgridview/:sgridview?',
        meta: {
            caption: 'entities.ibizsoftwaresuit.views.sgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsoftwaresuits', parameterName: 'ibizsoftwaresuit' },
                { pathName: 'sgridview', parameterName: 'sgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsoftware-suit-sgrid-view/ibizsoftware-suit-sgrid-view.vue'),
    },
    {
        path: '/ibizcustoms/:ibizcustom?/customeditview/:customeditview?',
        meta: {
            caption: 'entities.ibizcustom.views.customeditview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustoms', parameterName: 'ibizcustom' },
                { pathName: 'customeditview', parameterName: 'customeditview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustom-custom-edit-view/ibizcustom-custom-edit-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/f2treeexpview/:f2treeexpview?',
        meta: {
            caption: 'entities.ibizsample0003.views.f2treeexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'f2treeexpview', parameterName: 'f2treeexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-f2-tree-exp-view/ibizsample0003-f2-tree-exp-view.vue'),
    },
    {
        path: '/microcomponents/:microcomponent?/editview/:editview?',
        meta: {
            caption: 'entities.microcomponent.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'microcomponents', parameterName: 'microcomponent' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/micro-component-edit-view/micro-component-edit-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/f4treeexpview/:f4treeexpview?',
        meta: {
            caption: 'entities.ibizsample0003.views.f4treeexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'f4treeexpview', parameterName: 'f4treeexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-f4-tree-exp-view/ibizsample0003-f4-tree-exp-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ibizorderdetails/:ibizorderdetail?/sf1editview/:sf1editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sf1editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sf1editview', parameterName: 'sf1editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sf1-edit-view/ibizorder-detail-sf1-edit-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/sf1editview/:sf1editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sf1editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sf1editview', parameterName: 'sf1editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sf1-edit-view/ibizorder-detail-sf1-edit-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.ibizsample0003.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-pickup-grid-view/ibizsample0003-pickup-grid-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0002.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0002-edit-view/ibizsample0002-edit-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.ibizsample0002.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0002-pickup-grid-view/ibizsample0002-pickup-grid-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/indexpickupdataview/:indexpickupdataview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.indexpickupdataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'indexpickupdataview', parameterName: 'indexpickupdataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-index-pickup-data-view/ibizuniproduct-index-pickup-data-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/seditview2_layout/:seditview2_layout?',
        meta: {
            caption: 'entities.ibizorder.views.seditview2_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'seditview2_layout', parameterName: 'seditview2_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sedit-view2-layout/ibizorder-sedit-view2-layout.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2calendarview/:usr2calendarview?',
        meta: {
            caption: 'entities.ibizbook.views.usr2calendarview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2calendarview', parameterName: 'usr2calendarview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-calendar-view/ibizbookusr2-calendar-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr1110030546customview/:usr1110030546customview?',
        meta: {
            caption: 'entities.ibizbook.views.usr1110030546customview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr1110030546customview', parameterName: 'usr1110030546customview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr1110030546-custom-view/ibizbookusr1110030546-custom-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sgridview/:sgridview?',
        meta: {
            caption: 'entities.ibizorder.views.sgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sgridview', parameterName: 'sgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sgrid-view/ibizorder-sgrid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf2editview/:sf2editview?',
        meta: {
            caption: 'entities.ibizorder.views.sf2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf2editview', parameterName: 'sf2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf2-edit-view/ibizorder-sf2-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/formloadcustomview/:formloadcustomview?',
        meta: {
            caption: 'entities.ibizbook.views.formloadcustomview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'formloadcustomview', parameterName: 'formloadcustomview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookform-load-custom-view/ibizbookform-load-custom-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/sgridview_layout/:sgridview_layout?',
        meta: {
            caption: 'entities.ibizuniproduct.views.sgridview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'sgridview_layout', parameterName: 'sgridview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-sgrid-view-layout/ibizuniproduct-sgrid-view-layout.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibizuniproduct.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-grid-view9/ibizuniproduct-grid-view9.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2listview/:usr2listview?',
        meta: {
            caption: 'entities.ibizbook.views.usr2listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2listview', parameterName: 'usr2listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-list-view/ibizbookusr2-list-view.vue'),
    },
    {
        path: '/ibizappeditors/:ibizappeditor?/listview/:listview?',
        meta: {
            caption: 'entities.ibizappeditor.views.listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappeditors', parameterName: 'ibizappeditor' },
                { pathName: 'listview', parameterName: 'listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappeditorlist-view/ibizappeditorlist-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/f9editview/:f9editview?',
        meta: {
            caption: 'entities.ibizorder.views.f9editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'f9editview', parameterName: 'f9editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-f9-edit-view/ibizorder-f9-edit-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/indexpickupview/:indexpickupview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.indexpickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'indexpickupview', parameterName: 'indexpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-index-pickup-view/ibizuniproduct-index-pickup-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/dataviewexpview/:dataviewexpview?',
        meta: {
            caption: 'entities.ibizorder.views.dataviewexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'dataviewexpview', parameterName: 'dataviewexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-data-view-exp-view/ibizorder-data-view-exp-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2editview_layout/:usr2editview_layout?',
        meta: {
            caption: 'entities.ibizbook.views.usr2editview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2editview_layout', parameterName: 'usr2editview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-edit-view-layout/ibizbookusr2-edit-view-layout.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/wfdynaexpgridview/:wfdynaexpgridview?',
        meta: {
            caption: 'entities.ibizsample0021.views.wfdynaexpgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'wfdynaexpgridview', parameterName: 'wfdynaexpgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-wfdyna-exp-grid-view/ibizsample0021-wfdyna-exp-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ibizorderdetails/:ibizorderdetail?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-grid-view/ibizorder-detail-grid-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-grid-view/ibizorder-detail-grid-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/usr2pickupview/:usr2pickupview?',
        meta: {
            caption: 'entities.ibizcustomer.views.usr2pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'usr2pickupview', parameterName: 'usr2pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-usr2-pickup-view/ibizcustomer-usr2-pickup-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/pluginexgridview/:pluginexgridview?',
        meta: {
            caption: 'entities.ibizorder.views.pluginexgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'pluginexgridview', parameterName: 'pluginexgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-plugin-ex-grid-view/ibizorder-plugin-ex-grid-view.vue'),
    },
    {
        path: '/ibizhardwares/:ibizhardware?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibizhardware.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizhardware-grid-view9/ibizhardware-grid-view9.vue'),
    },
    {
        path: '/ibizappctrls/:ibizappctrl?/editview/:editview?',
        meta: {
            caption: 'entities.ibizappctrl.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappctrls', parameterName: 'ibizappctrl' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappctrledit-view/ibizappctrledit-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/usr2mpickupview/:usr2mpickupview?',
        meta: {
            caption: 'entities.ibizcustomer.views.usr2mpickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'usr2mpickupview', parameterName: 'usr2mpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-usr2-mpickup-view/ibizcustomer-usr2-mpickup-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/valuerulesgridview/:valuerulesgridview?',
        meta: {
            caption: 'entities.ibizbook.views.valuerulesgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'valuerulesgridview', parameterName: 'valuerulesgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookvalue-rules-grid-view/ibizbookvalue-rules-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2meditview9/:usr2meditview9?',
        meta: {
            caption: 'entities.ibizbook.views.usr2meditview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2meditview9', parameterName: 'usr2meditview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-medit-view9/ibizbookusr2-medit-view9.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/interfunceditview/:interfunceditview?',
        meta: {
            caption: 'entities.ibizbook.views.interfunceditview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'interfunceditview', parameterName: 'interfunceditview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookinter-func-edit-view/ibizbookinter-func-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/testcustomlayoutpanelgridexpview/:testcustomlayoutpanelgridexpview?',
        meta: {
            caption: 'entities.ibizorder.views.testcustomlayoutpanelgridexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'testcustomlayoutpanelgridexpview', parameterName: 'testcustomlayoutpanelgridexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-test-custom-layout-panel-grid-exp-view/ibizorder-test-custom-layout-panel-grid-exp-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/usr1215996830editview/:usr1215996830editview?',
        meta: {
            caption: 'entities.ibizorder.views.usr1215996830editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'usr1215996830editview', parameterName: 'usr1215996830editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-usr1215996830-edit-view/ibizorder-usr1215996830-edit-view.vue'),
    },
    {
        path: '/appportalview2/:appportalview2?',
        meta: {
            caption: 'app.views.appportalview2.caption',
            info:'',
            parameters: [
                { pathName: 'appportalview2', parameterName: 'appportalview2' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/app-portal-view2/app-portal-view2.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usreditview_plugin/:usreditview_plugin?',
        meta: {
            caption: 'entities.ibizbook.views.usreditview_plugin.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usreditview_plugin', parameterName: 'usreditview_plugin' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr-edit-view-plugin/ibizbookusr-edit-view-plugin.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizsample0003.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-grid-view/ibizsample0003-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr7editview/:usr7editview?',
        meta: {
            caption: 'entities.ibizbook.views.usr7editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr7editview', parameterName: 'usr7editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr7-edit-view/ibizbookusr7-edit-view.vue'),
    },
    {
        path: '/ibizhardwares/:ibizhardware?/indexpickupview/:indexpickupview?',
        meta: {
            caption: 'entities.ibizhardware.views.indexpickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                { pathName: 'indexpickupview', parameterName: 'indexpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizhardware-index-pickup-view/ibizhardware-index-pickup-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr4calendarview/:usr4calendarview?',
        meta: {
            caption: 'entities.ibizbook.views.usr4calendarview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr4calendarview', parameterName: 'usr4calendarview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr4-calendar-view/ibizbookusr4-calendar-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/dataviewexpview_layout/:dataviewexpview_layout?',
        meta: {
            caption: 'entities.ibizorder.views.dataviewexpview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'dataviewexpview_layout', parameterName: 'dataviewexpview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-data-view-exp-view-layout/ibizorder-data-view-exp-view-layout.vue'),
    },
    {
        path: '/ibizappeditors/:ibizappeditor?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizappeditor.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappeditors', parameterName: 'ibizappeditor' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappeditorgrid-view/ibizappeditorgrid-view.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/usr1114433946wfdynaeditview/:usr1114433946wfdynaeditview?',
        meta: {
            caption: 'entities.ibizsample0021.views.usr1114433946wfdynaeditview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'usr1114433946wfdynaeditview', parameterName: 'usr1114433946wfdynaeditview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-usr1114433946-wfdyna-edit-view/ibizsample0021-usr1114433946-wfdyna-edit-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/stabexpview_layout/:stabexpview_layout?',
        meta: {
            caption: 'entities.ibizsample0003.views.stabexpview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'stabexpview_layout', parameterName: 'stabexpview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-stab-exp-view-layout/ibizsample0003-stab-exp-view-layout.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/f3treeexpview/:f3treeexpview?',
        meta: {
            caption: 'entities.ibizsample0003.views.f3treeexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'f3treeexpview', parameterName: 'f3treeexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-f3-tree-exp-view/ibizsample0003-f3-tree-exp-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf4gridview/:sf4gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf4gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf4gridview', parameterName: 'sf4gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf4-grid-view/ibizorder-sf4-grid-view.vue'),
    },
    {
        path: '/ibiztasks/:ibiztask?/usr2editview/:usr2editview?',
        meta: {
            caption: 'entities.ibiztask.views.usr2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibiztasks', parameterName: 'ibiztask' },
                { pathName: 'usr2editview', parameterName: 'usr2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibiztaskusr2-edit-view/ibiztaskusr2-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf5gridview/:sf5gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf5gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf5gridview', parameterName: 'sf5gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf5-grid-view/ibizorder-sf5-grid-view.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/wfdynaeditview/:wfdynaeditview?',
        meta: {
            caption: 'entities.ibizsample0021.views.wfdynaeditview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'wfdynaeditview', parameterName: 'wfdynaeditview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-wfdyna-edit-view/ibizsample0021-wfdyna-edit-view.vue'),
    },
    {
        path: '/ibiztasks/:ibiztask?/ibiztaskteams/:ibiztaskteam?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibiztaskteam.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibiztasks', parameterName: 'ibiztask' },
                { pathName: 'ibiztaskteams', parameterName: 'ibiztaskteam' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibiztaskteamgrid-view9/ibiztaskteamgrid-view9.vue'),
    },
    {
        path: '/ibiztaskteams/:ibiztaskteam?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibiztaskteam.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibiztaskteams', parameterName: 'ibiztaskteam' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibiztaskteamgrid-view9/ibiztaskteamgrid-view9.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/sendbackwfdynaactionview/:sendbackwfdynaactionview?',
        meta: {
            caption: 'entities.ibizsample0021.views.sendbackwfdynaactionview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'sendbackwfdynaactionview', parameterName: 'sendbackwfdynaactionview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-sendbackwfdyna-action-view/ibizsample0021-sendbackwfdyna-action-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/usr2gridview/:usr2gridview?',
        meta: {
            caption: 'entities.ibizorder.views.usr2gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'usr2gridview', parameterName: 'usr2gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-usr2-grid-view/ibizorder-usr2-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/wizardiwithstateview/:wizardiwithstateview?',
        meta: {
            caption: 'entities.ibizbook.views.wizardiwithstateview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'wizardiwithstateview', parameterName: 'wizardiwithstateview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookwizard-iwith-state-view/ibizbookwizard-iwith-state-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr4gridview/:usr4gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr4gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr4gridview', parameterName: 'usr4gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr4-grid-view/ibizbookusr4-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/seditview2/:seditview2?',
        meta: {
            caption: 'entities.ibizorder.views.seditview2.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'seditview2', parameterName: 'seditview2' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sedit-view2/ibizorder-sedit-view2.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/seditview4/:seditview4?',
        meta: {
            caption: 'entities.ibizorder.views.seditview4.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'seditview4', parameterName: 'seditview4' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sedit-view4/ibizorder-sedit-view4.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/usr1114865995wfdynaeditview3/:usr1114865995wfdynaeditview3?',
        meta: {
            caption: 'entities.ibizsample0021.views.usr1114865995wfdynaeditview3.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'usr1114865995wfdynaeditview3', parameterName: 'usr1114865995wfdynaeditview3' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-usr1114865995-wfdyna-edit-view3/ibizsample0021-usr1114865995-wfdyna-edit-view3.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/mpickupview_layout/:mpickupview_layout?',
        meta: {
            caption: 'entities.ibizcustomer.views.mpickupview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'mpickupview_layout', parameterName: 'mpickupview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-mpickup-view-layout/ibizcustomer-mpickup-view-layout.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf3gridview/:sf3gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf3gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf3gridview', parameterName: 'sf3gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf3-grid-view/ibizorder-sf3-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/state30editview2/:state30editview2?',
        meta: {
            caption: 'entities.ibizorder.views.state30editview2.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'state30editview2', parameterName: 'state30editview2' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-state30-edit-view2/ibizorder-state30-edit-view2.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr6gridview/:usr6gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr6gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr6gridview', parameterName: 'usr6gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr6-grid-view/ibizbookusr6-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr5calendarview/:usr5calendarview?',
        meta: {
            caption: 'entities.ibizbook.views.usr5calendarview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr5calendarview', parameterName: 'usr5calendarview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr5-calendar-view/ibizbookusr5-calendar-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/editview/:editview?',
        meta: {
            caption: 'entities.ibizcustomer.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-edit-view/ibizcustomer-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/editview/:editview?',
        meta: {
            caption: 'entities.ibizbook.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookedit-view/ibizbookedit-view.vue'),
    },
    {
        path: '/ibizappextendeditors/:ibizappextendeditor?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizappextendeditor.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappextendeditors', parameterName: 'ibizappextendeditor' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappextendeditorgrid-view/ibizappextendeditorgrid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/f8editview/:f8editview?',
        meta: {
            caption: 'entities.ibizorder.views.f8editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'f8editview', parameterName: 'f8editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-f8-edit-view/ibizorder-f8-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/seditview3_layout/:seditview3_layout?',
        meta: {
            caption: 'entities.ibizorder.views.seditview3_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'seditview3_layout', parameterName: 'seditview3_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sedit-view3-layout/ibizorder-sedit-view3-layout.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/interfunckanbanview_layout/:interfunckanbanview_layout?',
        meta: {
            caption: 'entities.ibizbook.views.interfunckanbanview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'interfunckanbanview_layout', parameterName: 'interfunckanbanview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookinter-func-kan-ban-view-layout/ibizbookinter-func-kan-ban-view-layout.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf20gridview/:sf20gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf20gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf20gridview', parameterName: 'sf20gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf20-grid-view/ibizorder-sf20-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/usr2chartview/:usr2chartview?',
        meta: {
            caption: 'entities.ibizorder.views.usr2chartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'usr2chartview', parameterName: 'usr2chartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-usr2-chart-view/ibizorder-usr2-chart-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usrgridview_colplugin/:usrgridview_colplugin?',
        meta: {
            caption: 'entities.ibizbook.views.usrgridview_colplugin.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usrgridview_colplugin', parameterName: 'usrgridview_colplugin' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr-grid-view-col-plugin/ibizbookusr-grid-view-col-plugin.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr3calendarview/:usr3calendarview?',
        meta: {
            caption: 'entities.ibizbook.views.usr3calendarview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr3calendarview', parameterName: 'usr3calendarview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr3-calendar-view/ibizbookusr3-calendar-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/usr3editview/:usr3editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.usr3editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'usr3editview', parameterName: 'usr3editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-usr3-edit-view/ibizsample0001-usr3-edit-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/usr3editview/:usr3editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.usr3editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'usr3editview', parameterName: 'usr3editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-usr3-edit-view/ibizsample0001-usr3-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ibizorderdetails/:ibizorderdetail?/seditview9/:seditview9?',
        meta: {
            caption: 'entities.ibizorderdetail.views.seditview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'seditview9', parameterName: 'seditview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sedit-view9/ibizorder-detail-sedit-view9.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/seditview9/:seditview9?',
        meta: {
            caption: 'entities.ibizorderdetail.views.seditview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'seditview9', parameterName: 'seditview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sedit-view9/ibizorder-detail-sedit-view9.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizorder.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-grid-view/ibizorder-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/optionview/:optionview?',
        meta: {
            caption: 'entities.ibizbook.views.optionview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'optionview', parameterName: 'optionview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookoption-view/ibizbookoption-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/roweditgridview/:roweditgridview?',
        meta: {
            caption: 'entities.ibizbook.views.roweditgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'roweditgridview', parameterName: 'roweditgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookrow-edit-grid-view/ibizbookrow-edit-grid-view.vue'),
    },
    {
        path: '/ibizhardwares/:ibizhardware?/sgridview/:sgridview?',
        meta: {
            caption: 'entities.ibizhardware.views.sgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                { pathName: 'sgridview', parameterName: 'sgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizhardware-sgrid-view/ibizhardware-sgrid-view.vue'),
    },
    {
        path: '/ibizcustomer_intfs/:ibizcustomer_intf?/mpickupview/:mpickupview?',
        meta: {
            caption: 'entities.ibizcustomer_intf.views.mpickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomer_intfs', parameterName: 'ibizcustomer_intf' },
                { pathName: 'mpickupview', parameterName: 'mpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-intfmpickup-view/ibizcustomer-intfmpickup-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/optionview_layout/:optionview_layout?',
        meta: {
            caption: 'entities.ibizbook.views.optionview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'optionview_layout', parameterName: 'optionview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookoption-view-layout/ibizbookoption-view-layout.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/pickuptreeview/:pickuptreeview?',
        meta: {
            caption: 'entities.ibizcustomer.views.pickuptreeview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'pickuptreeview', parameterName: 'pickuptreeview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-pickup-tree-view/ibizcustomer-pickup-tree-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ctrlpluginexgridview/:ctrlpluginexgridview?',
        meta: {
            caption: 'entities.ibizorder.views.ctrlpluginexgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ctrlpluginexgridview', parameterName: 'ctrlpluginexgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-ctrl-plugin-ex-grid-view/ibizorder-ctrl-plugin-ex-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/editview_info/:editview_info?',
        meta: {
            caption: 'entities.ibizorder.views.editview_info.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'editview_info', parameterName: 'editview_info' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-edit-view-info/ibizorder-edit-view-info.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/wfstartview/:wfstartview?',
        meta: {
            caption: 'entities.ibizorder.views.wfstartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'wfstartview', parameterName: 'wfstartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-wfstart-view/ibizorder-wfstart-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/piechartview/:piechartview?',
        meta: {
            caption: 'entities.ibizorder.views.piechartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'piechartview', parameterName: 'piechartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-pie-chart-view/ibizorder-pie-chart-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/interfunceditview_layout/:interfunceditview_layout?',
        meta: {
            caption: 'entities.ibizbook.views.interfunceditview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'interfunceditview_layout', parameterName: 'interfunceditview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookinter-func-edit-view-layout/ibizbookinter-func-edit-view-layout.vue'),
    },
    {
        path: '/ibizappeditors/:ibizappeditor?/editview/:editview?',
        meta: {
            caption: 'entities.ibizappeditor.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappeditors', parameterName: 'ibizappeditor' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappeditoredit-view/ibizappeditoredit-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/f1treeexpview/:f1treeexpview?',
        meta: {
            caption: 'entities.ibizsample0003.views.f1treeexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'f1treeexpview', parameterName: 'f1treeexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-f1-tree-exp-view/ibizsample0003-f1-tree-exp-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/calendarexpview/:calendarexpview?',
        meta: {
            caption: 'entities.ibizorder.views.calendarexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'calendarexpview', parameterName: 'calendarexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-calendar-exp-view/ibizorder-calendar-exp-view.vue'),
    },
    {
        path: '/ibizcpus/:ibizcpu?/editview/:editview?',
        meta: {
            caption: 'entities.ibizcpu.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcpus', parameterName: 'ibizcpu' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcpuedit-view/ibizcpuedit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/treegridexview_layout/:treegridexview_layout?',
        meta: {
            caption: 'entities.ibizorder.views.treegridexview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'treegridexview_layout', parameterName: 'treegridexview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-tree-grid-ex-view-layout/ibizorder-tree-grid-ex-view-layout.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf4editview/:sf4editview?',
        meta: {
            caption: 'entities.ibizorder.views.sf4editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf4editview', parameterName: 'sf4editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf4-edit-view/ibizorder-sf4-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/barchartview/:barchartview?',
        meta: {
            caption: 'entities.ibizorder.views.barchartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'barchartview', parameterName: 'barchartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-bar-chart-view/ibizorder-bar-chart-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf2editview/:sf2editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf2editview', parameterName: 'sf2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf2-edit-view/ibizsample0001-sf2-edit-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/sf2editview/:sf2editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf2editview', parameterName: 'sf2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf2-edit-view/ibizsample0001-sf2-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/viewpluginexgridview/:viewpluginexgridview?',
        meta: {
            caption: 'entities.ibizorder.views.viewpluginexgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'viewpluginexgridview', parameterName: 'viewpluginexgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-view-plugin-ex-grid-view/ibizorder-view-plugin-ex-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/testclcalendarview/:testclcalendarview?',
        meta: {
            caption: 'entities.ibizbook.views.testclcalendarview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'testclcalendarview', parameterName: 'testclcalendarview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbooktest-clcalendar-view/ibizbooktest-clcalendar-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ibizorderdetails/:ibizorderdetail?/editview/:editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-edit-view/ibizorder-detail-edit-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/editview/:editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-edit-view/ibizorder-detail-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usreditview_ctrlplugin/:usreditview_ctrlplugin?',
        meta: {
            caption: 'entities.ibizbook.views.usreditview_ctrlplugin.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usreditview_ctrlplugin', parameterName: 'usreditview_ctrlplugin' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr-edit-view-ctrl-plugin/ibizbookusr-edit-view-ctrl-plugin.vue'),
    },
            {
                path: '/ibizuniproducts/:ibizuniproduct?/redirectview/:redirectview?',
                meta: {
                    caption: 'entities.ibizuniproduct.views.redirectview.caption',
                    info:'',
                    viewType: 'REDIRECTVIEW',
                    parameters: [
                        { pathName: 'appindexview2', parameterName: 'appindexview2' },
                        { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                        { pathName: 'redirectview', parameterName: 'redirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/sample/ibizuniproduct-redirect-view/ibizuniproduct-redirect-view.vue'),
            },
    {
        path: '/ibizorders/:ibizorder?/ibizorderdetails/:ibizorderdetail?/sf2editview/:sf2editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sf2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sf2editview', parameterName: 'sf2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sf2-edit-view/ibizorder-detail-sf2-edit-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/sf2editview/:sf2editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sf2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sf2editview', parameterName: 'sf2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sf2-edit-view/ibizorder-detail-sf2-edit-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/mediatesteditview/:mediatesteditview?',
        meta: {
            caption: 'entities.ibizcustomer.views.mediatesteditview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'mediatesteditview', parameterName: 'mediatesteditview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-media-test-edit-view/ibizcustomer-media-test-edit-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/stabexpview/:stabexpview?',
        meta: {
            caption: 'entities.ibizsample0003.views.stabexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'stabexpview', parameterName: 'stabexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-stab-exp-view/ibizsample0003-stab-exp-view.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/addstepafterwfdynaactionview/:addstepafterwfdynaactionview?',
        meta: {
            caption: 'entities.ibizsample0021.views.addstepafterwfdynaactionview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'addstepafterwfdynaactionview', parameterName: 'addstepafterwfdynaactionview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-addstepafterwfdyna-action-view/ibizsample0021-addstepafterwfdyna-action-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/editview/:editview?',
        meta: {
            caption: 'entities.ibizorder.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-edit-view/ibizorder-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/usr3editview/:usr3editview?',
        meta: {
            caption: 'entities.ibizorder.views.usr3editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'usr3editview', parameterName: 'usr3editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-usr3-edit-view/ibizorder-usr3-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ganttview_layout/:ganttview_layout?',
        meta: {
            caption: 'entities.ibizorder.views.ganttview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ganttview_layout', parameterName: 'ganttview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-gantt-view-layout/ibizorder-gantt-view-layout.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/linechartview/:linechartview?',
        meta: {
            caption: 'entities.ibizorder.views.linechartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'linechartview', parameterName: 'linechartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-line-chart-view/ibizorder-line-chart-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/usr2mpickupview_layout/:usr2mpickupview_layout?',
        meta: {
            caption: 'entities.ibizcustomer.views.usr2mpickupview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'usr2mpickupview_layout', parameterName: 'usr2mpickupview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-usr2-mpickup-view-layout/ibizcustomer-usr2-mpickup-view-layout.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2meditview9_layout/:usr2meditview9_layout?',
        meta: {
            caption: 'entities.ibizbook.views.usr2meditview9_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2meditview9_layout', parameterName: 'usr2meditview9_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-medit-view9-layout/ibizbookusr2-medit-view9-layout.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usrtreeview_plugin/:usrtreeview_plugin?',
        meta: {
            caption: 'entities.ibizbook.views.usrtreeview_plugin.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usrtreeview_plugin', parameterName: 'usrtreeview_plugin' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr-tree-view-plugin/ibizbookusr-tree-view-plugin.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/seditview4_layout/:seditview4_layout?',
        meta: {
            caption: 'entities.ibizorder.views.seditview4_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'seditview4_layout', parameterName: 'seditview4_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sedit-view4-layout/ibizorder-sedit-view4-layout.vue'),
    },
    {
        path: '/ibizsoftwaresuits/:ibizsoftwaresuit?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsoftwaresuit.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsoftwaresuits', parameterName: 'ibizsoftwaresuit' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsoftware-suit-edit-view/ibizsoftware-suit-edit-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/usr3editview/:usr3editview?',
        meta: {
            caption: 'entities.ibizcustomer.views.usr3editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'usr3editview', parameterName: 'usr3editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-usr3-edit-view/ibizcustomer-usr3-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/calendarexpview_layout/:calendarexpview_layout?',
        meta: {
            caption: 'entities.ibizorder.views.calendarexpview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'calendarexpview_layout', parameterName: 'calendarexpview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-calendar-exp-view-layout/ibizorder-calendar-exp-view-layout.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/proivateplugingridview/:proivateplugingridview?',
        meta: {
            caption: 'entities.ibizorder.views.proivateplugingridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'proivateplugingridview', parameterName: 'proivateplugingridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-proivate-plugin-grid-view/ibizorder-proivate-plugin-grid-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/pickupview_layout/:pickupview_layout?',
        meta: {
            caption: 'entities.ibizcustomer.views.pickupview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'pickupview_layout', parameterName: 'pickupview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-pickup-view-layout/ibizcustomer-pickup-view-layout.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf6editview/:sf6editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf6editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf6editview', parameterName: 'sf6editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf6-edit-view/ibizsample0001-sf6-edit-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/sf6editview/:sf6editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf6editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf6editview', parameterName: 'sf6editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf6-edit-view/ibizsample0001-sf6-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr3editview/:usr3editview?',
        meta: {
            caption: 'entities.ibizbook.views.usr3editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr3editview', parameterName: 'usr3editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr3-edit-view/ibizbookusr3-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/groupbycodelistkanbanview/:groupbycodelistkanbanview?',
        meta: {
            caption: 'entities.ibizbook.views.groupbycodelistkanbanview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'groupbycodelistkanbanview', parameterName: 'groupbycodelistkanbanview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookgroup-by-codelist-kan-ban-view/ibizbookgroup-by-codelist-kan-ban-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/usr2editview/:usr2editview?',
        meta: {
            caption: 'entities.ibizorder.views.usr2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'usr2editview', parameterName: 'usr2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-usr2-edit-view/ibizorder-usr2-edit-view.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/usr1116491232wfdynastartview/:usr1116491232wfdynastartview?',
        meta: {
            caption: 'entities.ibizsample0021.views.usr1116491232wfdynastartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'usr1116491232wfdynastartview', parameterName: 'usr1116491232wfdynastartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-usr1116491232-wfdyna-start-view/ibizsample0021-usr1116491232-wfdyna-start-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ibizorderdetails/:ibizorderdetail?/listview/:listview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'listview', parameterName: 'listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-list-view/ibizorder-detail-list-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/listview/:listview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'listview', parameterName: 'listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-list-view/ibizorder-detail-list-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr6listview/:usr6listview?',
        meta: {
            caption: 'entities.ibizbook.views.usr6listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr6listview', parameterName: 'usr6listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr6-list-view/ibizbookusr6-list-view.vue'),
    },
    {
        path: '/ibizsample0018s/:ibizsample0018?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizsample0018.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0018s', parameterName: 'ibizsample0018' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0018-grid-view/ibizsample0018-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/exportandimportgridview/:exportandimportgridview?',
        meta: {
            caption: 'entities.ibizbook.views.exportandimportgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'exportandimportgridview', parameterName: 'exportandimportgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookexport-and-import-grid-view/ibizbookexport-and-import-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibizorder.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-grid-view9/ibizorder-grid-view9.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/autogrouplistview/:autogrouplistview?',
        meta: {
            caption: 'entities.ibizbook.views.autogrouplistview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'autogrouplistview', parameterName: 'autogrouplistview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookauto-group-list-view/ibizbookauto-group-list-view.vue'),
    },
    {
        path: '/ibizappviews/:ibizappview?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizappview.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappviews', parameterName: 'ibizappview' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappviewgrid-view/ibizappviewgrid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr3listview/:usr3listview?',
        meta: {
            caption: 'entities.ibizbook.views.usr3listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr3listview', parameterName: 'usr3listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr3-list-view/ibizbookusr3-list-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf6gridview/:sf6gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf6gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf6gridview', parameterName: 'sf6gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf6-grid-view/ibizorder-sf6-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/meditview9/:meditview9?',
        meta: {
            caption: 'entities.ibizbook.views.meditview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'meditview9', parameterName: 'meditview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookmedit-view9/ibizbookmedit-view9.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2treeview/:usr2treeview?',
        meta: {
            caption: 'entities.ibizbook.views.usr2treeview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2treeview', parameterName: 'usr2treeview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-tree-view/ibizbookusr2-tree-view.vue'),
    },
            {
                path: '/ibizbooks/:ibizbook?/redirectview/:redirectview?',
                meta: {
                    caption: 'entities.ibizbook.views.redirectview.caption',
                    info:'',
                    viewType: 'REDIRECTVIEW',
                    parameters: [
                        { pathName: 'appindexview2', parameterName: 'appindexview2' },
                        { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                        { pathName: 'redirectview', parameterName: 'redirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/sample/ibizbookredirect-view/ibizbookredirect-view.vue'),
            },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-pickup-view/ibizuniproduct-pickup-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/radarchartview/:radarchartview?',
        meta: {
            caption: 'entities.ibizorder.views.radarchartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'radarchartview', parameterName: 'radarchartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-radar-chart-view/ibizorder-radar-chart-view.vue'),
    },
    {
        path: '/ibizappctrls/:ibizappctrl?/listview/:listview?',
        meta: {
            caption: 'entities.ibizappctrl.views.listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappctrls', parameterName: 'ibizappctrl' },
                { pathName: 'listview', parameterName: 'listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappctrllist-view/ibizappctrllist-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/listexpview_layout/:listexpview_layout?',
        meta: {
            caption: 'entities.ibizorder.views.listexpview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'listexpview_layout', parameterName: 'listexpview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-list-exp-view-layout/ibizorder-list-exp-view-layout.vue'),
    },
    {
        path: '/ibizsample0014s/:ibizsample0014?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizsample0014.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0014s', parameterName: 'ibizsample0014' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0014-grid-view/ibizsample0014-grid-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.ibizsample0003.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-pickup-view/ibizsample0003-pickup-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf7editview/:sf7editview?',
        meta: {
            caption: 'entities.ibizorder.views.sf7editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf7editview', parameterName: 'sf7editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf7-edit-view/ibizorder-sf7-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ibizorderdetails/:ibizorderdetail?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibizorderdetail.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-grid-view9/ibizorder-detail-grid-view9.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibizorderdetail.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-grid-view9/ibizorder-detail-grid-view9.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/wfdynaactionview_layout/:wfdynaactionview_layout?',
        meta: {
            caption: 'entities.ibizsample0021.views.wfdynaactionview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'wfdynaactionview_layout', parameterName: 'wfdynaactionview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-wfdyna-action-view-layout/ibizsample0021-wfdyna-action-view-layout.vue'),
    },
    {
        path: '/ibizstorages/:ibizstorage?/editview/:editview?',
        meta: {
            caption: 'entities.ibizstorage.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizstorages', parameterName: 'ibizstorage' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizstorage-edit-view/ibizstorage-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/customview/:customview?',
        meta: {
            caption: 'entities.ibizbook.views.customview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'customview', parameterName: 'customview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookcustom-view/ibizbookcustom-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr4listview/:usr4listview?',
        meta: {
            caption: 'entities.ibizbook.views.usr4listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr4listview', parameterName: 'usr4listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr4-list-view/ibizbookusr4-list-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/mpickupview/:mpickupview?',
        meta: {
            caption: 'entities.ibizcustomer.views.mpickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'mpickupview', parameterName: 'mpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-mpickup-view/ibizcustomer-mpickup-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ibizorderdetails/:ibizorderdetail?/sgridview9/:sgridview9?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sgridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sgridview9', parameterName: 'sgridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sgrid-view9/ibizorder-detail-sgrid-view9.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/sgridview9/:sgridview9?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sgridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sgridview9', parameterName: 'sgridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sgrid-view9/ibizorder-detail-sgrid-view9.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizsample0021.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-grid-view/ibizsample0021-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2dataview/:usr2dataview?',
        meta: {
            caption: 'entities.ibizbook.views.usr2dataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2dataview', parameterName: 'usr2dataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-data-view/ibizbookusr2-data-view.vue'),
    },
    {
        path: '/ibizhardwares/:ibizhardware?/editview/:editview?',
        meta: {
            caption: 'entities.ibizhardware.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizhardware-edit-view/ibizhardware-edit-view.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0021.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-edit-view/ibizsample0021-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/dataview/:dataview?',
        meta: {
            caption: 'entities.ibizbook.views.dataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'dataview', parameterName: 'dataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookdata-view/ibizbookdata-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/areachartview/:areachartview?',
        meta: {
            caption: 'entities.ibizorder.views.areachartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'areachartview', parameterName: 'areachartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-area-chart-view/ibizorder-area-chart-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usrwizardview_plugin/:usrwizardview_plugin?',
        meta: {
            caption: 'entities.ibizbook.views.usrwizardview_plugin.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usrwizardview_plugin', parameterName: 'usrwizardview_plugin' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr-wizard-view-plugin/ibizbookusr-wizard-view-plugin.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr6dataview/:usr6dataview?',
        meta: {
            caption: 'entities.ibizbook.views.usr6dataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr6dataview', parameterName: 'usr6dataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr6-data-view/ibizbookusr6-data-view.vue'),
    },
    {
        path: '/ibizsample0018s/:ibizsample0018?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0018.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0018s', parameterName: 'ibizsample0018' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0018-edit-view/ibizsample0018-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ibizorderdetails/:ibizorderdetail?/sgridview/:sgridview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sgridview', parameterName: 'sgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sgrid-view/ibizorder-detail-sgrid-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/sgridview/:sgridview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sgridview', parameterName: 'sgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sgrid-view/ibizorder-detail-sgrid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/dataviewexpview/:dataviewexpview?',
        meta: {
            caption: 'entities.ibizbook.views.dataviewexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'dataviewexpview', parameterName: 'dataviewexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookdata-view-exp-view/ibizbookdata-view-exp-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf4editview/:sf4editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf4editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf4editview', parameterName: 'sf4editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf4-edit-view/ibizsample0001-sf4-edit-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/sf4editview/:sf4editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf4editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf4editview', parameterName: 'sf4editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf4-edit-view/ibizsample0001-sf4-edit-view.vue'),
    },
            {
                path: '/ibizorders/:ibizorder?/redirectview/:redirectview?',
                meta: {
                    caption: 'entities.ibizorder.views.redirectview.caption',
                    info:'',
                    viewType: 'REDIRECTVIEW',
                    parameters: [
                        { pathName: 'appindexview2', parameterName: 'appindexview2' },
                        { pathName: 'ibizorders', parameterName: 'ibizorder' },
                        { pathName: 'redirectview', parameterName: 'redirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/sample/ibizorder-redirect-view/ibizorder-redirect-view.vue'),
            },
    {
        path: '/ibizorders/:ibizorder?/testclchartview/:testclchartview?',
        meta: {
            caption: 'entities.ibizorder.views.testclchartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'testclchartview', parameterName: 'testclchartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-test-clchart-view/ibizorder-test-clchart-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/newdefaultvaluegridview/:newdefaultvaluegridview?',
        meta: {
            caption: 'entities.ibizbook.views.newdefaultvaluegridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'newdefaultvaluegridview', parameterName: 'newdefaultvaluegridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbooknew-default-value-grid-view/ibizbooknew-default-value-grid-view.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/reassignwfdynaactionview/:reassignwfdynaactionview?',
        meta: {
            caption: 'entities.ibizsample0021.views.reassignwfdynaactionview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'reassignwfdynaactionview', parameterName: 'reassignwfdynaactionview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-reassignwfdyna-action-view/ibizsample0021-reassignwfdyna-action-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/f19editview/:f19editview?',
        meta: {
            caption: 'entities.ibizorder.views.f19editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'f19editview', parameterName: 'f19editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-f19-edit-view/ibizorder-f19-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr3dataview/:usr3dataview?',
        meta: {
            caption: 'entities.ibizbook.views.usr3dataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr3dataview', parameterName: 'usr3dataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr3-data-view/ibizbookusr3-data-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/seditview3/:seditview3?',
        meta: {
            caption: 'entities.ibizorder.views.seditview3.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'seditview3', parameterName: 'seditview3' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sedit-view3/ibizorder-sedit-view3.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/listexpview/:listexpview?',
        meta: {
            caption: 'entities.ibizorder.views.listexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'listexpview', parameterName: 'listexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-list-exp-view/ibizorder-list-exp-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr5editview/:usr5editview?',
        meta: {
            caption: 'entities.ibizbook.views.usr5editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr5editview', parameterName: 'usr5editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr5-edit-view/ibizbookusr5-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/wizardview/:wizardview?',
        meta: {
            caption: 'entities.ibizbook.views.wizardview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'wizardview', parameterName: 'wizardview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookwizard-view/ibizbookwizard-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr5listview/:usr5listview?',
        meta: {
            caption: 'entities.ibizbook.views.usr5listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr5listview', parameterName: 'usr5listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr5-list-view/ibizbookusr5-list-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usrgridview_plugin/:usrgridview_plugin?',
        meta: {
            caption: 'entities.ibizbook.views.usrgridview_plugin.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usrgridview_plugin', parameterName: 'usrgridview_plugin' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr-grid-view-plugin/ibizbookusr-grid-view-plugin.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/mpickupview/:mpickupview?',
        meta: {
            caption: 'entities.ibizsample0002.views.mpickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'mpickupview', parameterName: 'mpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0002-mpickup-view/ibizsample0002-mpickup-view.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/wfdynaexpgridview_layout/:wfdynaexpgridview_layout?',
        meta: {
            caption: 'entities.ibizsample0021.views.wfdynaexpgridview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'wfdynaexpgridview_layout', parameterName: 'wfdynaexpgridview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-wfdyna-exp-grid-view-layout/ibizsample0021-wfdyna-exp-grid-view-layout.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ganttview/:ganttview?',
        meta: {
            caption: 'entities.ibizorder.views.ganttview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ganttview', parameterName: 'ganttview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-gantt-view/ibizorder-gantt-view.vue'),
    },
    {
        path: '/ibizcustomer_intfs/:ibizcustomer_intf?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.ibizcustomer_intf.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomer_intfs', parameterName: 'ibizcustomer_intf' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-intfpickup-grid-view/ibizcustomer-intfpickup-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usroptionview/:usroptionview?',
        meta: {
            caption: 'entities.ibizbook.views.usroptionview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usroptionview', parameterName: 'usroptionview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr-option-view/ibizbookusr-option-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/wizardview_layout/:wizardview_layout?',
        meta: {
            caption: 'entities.ibizbook.views.wizardview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'wizardview_layout', parameterName: 'wizardview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookwizard-view-layout/ibizbookwizard-view-layout.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/interfunckanbanview/:interfunckanbanview?',
        meta: {
            caption: 'entities.ibizbook.views.interfunckanbanview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'interfunckanbanview', parameterName: 'interfunckanbanview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookinter-func-kan-ban-view/ibizbookinter-func-kan-ban-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.ibizorder.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-pickup-grid-view/ibizorder-pickup-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usrgridview_ctrlplugin/:usrgridview_ctrlplugin?',
        meta: {
            caption: 'entities.ibizbook.views.usrgridview_ctrlplugin.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usrgridview_ctrlplugin', parameterName: 'usrgridview_ctrlplugin' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr-grid-view-ctrl-plugin/ibizbookusr-grid-view-ctrl-plugin.vue'),
    },
    {
        path: '/ibizsoftwaresuits/:ibizsoftwaresuit?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibizsoftwaresuit.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsoftwaresuits', parameterName: 'ibizsoftwaresuit' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsoftware-suit-grid-view9/ibizsoftware-suit-grid-view9.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf5editview/:sf5editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf5editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf5editview', parameterName: 'sf5editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf5-edit-view/ibizsample0001-sf5-edit-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/sf5editview/:sf5editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf5editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf5editview', parameterName: 'sf5editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf5-edit-view/ibizsample0001-sf5-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2customview/:usr2customview?',
        meta: {
            caption: 'entities.ibizbook.views.usr2customview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2customview', parameterName: 'usr2customview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-custom-view/ibizbookusr2-custom-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/haspanellistview/:haspanellistview?',
        meta: {
            caption: 'entities.ibizbook.views.haspanellistview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'haspanellistview', parameterName: 'haspanellistview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookhas-panel-list-view/ibizbookhas-panel-list-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/ibizorderdetails/:ibizorderdetail?/usr3editview/:usr3editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.usr3editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'usr3editview', parameterName: 'usr3editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-usr3-edit-view/ibizorder-detail-usr3-edit-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/usr3editview/:usr3editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.usr3editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'usr3editview', parameterName: 'usr3editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-usr3-edit-view/ibizorder-detail-usr3-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr10gridview/:usr10gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr10gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr10gridview', parameterName: 'usr10gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr10-grid-view/ibizbookusr10-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/calendarview/:calendarview?',
        meta: {
            caption: 'entities.ibizbook.views.calendarview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'calendarview', parameterName: 'calendarview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookcalendar-view/ibizbookcalendar-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0003.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-edit-view/ibizsample0003-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usrlistview_plugin/:usrlistview_plugin?',
        meta: {
            caption: 'entities.ibizbook.views.usrlistview_plugin.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usrlistview_plugin', parameterName: 'usrlistview_plugin' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr-list-view-plugin/ibizbookusr-list-view-plugin.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/updatedefaultgridview/:updatedefaultgridview?',
        meta: {
            caption: 'entities.ibizbook.views.updatedefaultgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'updatedefaultgridview', parameterName: 'updatedefaultgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookupdate-default-grid-view/ibizbookupdate-default-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/treegridexview/:treegridexview?',
        meta: {
            caption: 'entities.ibizorder.views.treegridexview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'treegridexview', parameterName: 'treegridexview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-tree-grid-ex-view/ibizorder-tree-grid-ex-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/state10editview2/:state10editview2?',
        meta: {
            caption: 'entities.ibizorder.views.state10editview2.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'state10editview2', parameterName: 'state10editview2' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-state10-edit-view2/ibizorder-state10-edit-view2.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usrpickupview_plugin/:usrpickupview_plugin?',
        meta: {
            caption: 'entities.ibizbook.views.usrpickupview_plugin.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usrpickupview_plugin', parameterName: 'usrpickupview_plugin' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr-pickup-view-plugin/ibizbookusr-pickup-view-plugin.vue'),
    },
    {
        path: '/ibiztasks/:ibiztask?/ibiztaskteams/:ibiztaskteam?/editview9/:editview9?',
        meta: {
            caption: 'entities.ibiztaskteam.views.editview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibiztasks', parameterName: 'ibiztask' },
                { pathName: 'ibiztaskteams', parameterName: 'ibiztaskteam' },
                { pathName: 'editview9', parameterName: 'editview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibiztaskteamedit-view9/ibiztaskteamedit-view9.vue'),
    },
    {
        path: '/ibiztaskteams/:ibiztaskteam?/editview9/:editview9?',
        meta: {
            caption: 'entities.ibiztaskteam.views.editview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibiztaskteams', parameterName: 'ibiztaskteam' },
                { pathName: 'editview9', parameterName: 'editview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibiztaskteamedit-view9/ibiztaskteamedit-view9.vue'),
    },
    {
        path: '/ibizappviews/:ibizappview?/listview/:listview?',
        meta: {
            caption: 'entities.ibizappview.views.listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappviews', parameterName: 'ibizappview' },
                { pathName: 'listview', parameterName: 'listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappviewlist-view/ibizappviewlist-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr8editview/:usr8editview?',
        meta: {
            caption: 'entities.ibizbook.views.usr8editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr8editview', parameterName: 'usr8editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr8-edit-view/ibizbookusr8-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/listview/:listview?',
        meta: {
            caption: 'entities.ibizbook.views.listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'listview', parameterName: 'listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbooklist-view/ibizbooklist-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/ruleseditview/:ruleseditview?',
        meta: {
            caption: 'entities.ibizbook.views.ruleseditview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'ruleseditview', parameterName: 'ruleseditview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookrules-edit-view/ibizbookrules-edit-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-pickup-grid-view/ibizuniproduct-pickup-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/treeexpview/:treeexpview?',
        meta: {
            caption: 'entities.ibizorder.views.treeexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'treeexpview', parameterName: 'treeexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-tree-exp-view/ibizorder-tree-exp-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf1editview/:sf1editview?',
        meta: {
            caption: 'entities.ibizorder.views.sf1editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf1editview', parameterName: 'sf1editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf1-edit-view/ibizorder-sf1-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2editview/:usr2editview?',
        meta: {
            caption: 'entities.ibizbook.views.usr2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2editview', parameterName: 'usr2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-edit-view/ibizbookusr2-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/state40editview2/:state40editview2?',
        meta: {
            caption: 'entities.ibizorder.views.state40editview2.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'state40editview2', parameterName: 'state40editview2' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-state40-edit-view2/ibizorder-state40-edit-view2.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/testlogiccustomview/:testlogiccustomview?',
        meta: {
            caption: 'entities.ibizbook.views.testlogiccustomview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'testlogiccustomview', parameterName: 'testlogiccustomview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbooktest-logic-custom-view/ibizbooktest-logic-custom-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/usr2pickupview_layout/:usr2pickupview_layout?',
        meta: {
            caption: 'entities.ibizcustomer.views.usr2pickupview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'usr2pickupview_layout', parameterName: 'usr2pickupview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-usr2-pickup-view-layout/ibizcustomer-usr2-pickup-view-layout.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr4listview_layout/:usr4listview_layout?',
        meta: {
            caption: 'entities.ibizbook.views.usr4listview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr4listview_layout', parameterName: 'usr4listview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr4-list-view-layout/ibizbookusr4-list-view-layout.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf1gridview/:sf1gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf1gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf1gridview', parameterName: 'sf1gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf1-grid-view/ibizorder-sf1-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr5dataview/:usr5dataview?',
        meta: {
            caption: 'entities.ibizbook.views.usr5dataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr5dataview', parameterName: 'usr5dataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr5-data-view/ibizbookusr5-data-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/treeexpview_layout/:treeexpview_layout?',
        meta: {
            caption: 'entities.ibizorder.views.treeexpview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'treeexpview_layout', parameterName: 'treeexpview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-tree-exp-view-layout/ibizorder-tree-exp-view-layout.vue'),
    },
    {
        path: '/ibizappextendeditors/:ibizappextendeditor?/editview/:editview?',
        meta: {
            caption: 'entities.ibizappextendeditor.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappextendeditors', parameterName: 'ibizappextendeditor' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappextendeditoredit-view/ibizappextendeditoredit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr3gridview/:usr3gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr3gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr3gridview', parameterName: 'usr3gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr3-grid-view/ibizbookusr3-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/gridexpview/:gridexpview?',
        meta: {
            caption: 'entities.ibizorder.views.gridexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'gridexpview', parameterName: 'gridexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-grid-exp-view/ibizorder-grid-exp-view.vue'),
    },
    {
        path: '/ibizsample0014s/:ibizsample0014?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0014.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0014s', parameterName: 'ibizsample0014' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0014-edit-view/ibizsample0014-edit-view.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/gridview_layout/:gridview_layout?',
        meta: {
            caption: 'entities.ibizsample0021.views.gridview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'gridview_layout', parameterName: 'gridview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-grid-view-layout/ibizsample0021-grid-view-layout.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.ibizorder.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-pickup-view/ibizorder-pickup-view.vue'),
    },
    {
        path: '/ibizappctrls/:ibizappctrl?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizappctrl.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappctrls', parameterName: 'ibizappctrl' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappctrlgrid-view/ibizappctrlgrid-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.ibizcustomer.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-pickup-view/ibizcustomer-pickup-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr4editview/:usr4editview?',
        meta: {
            caption: 'entities.ibizbook.views.usr4editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr4editview', parameterName: 'usr4editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr4-edit-view/ibizbookusr4-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/tabexpview/:tabexpview?',
        meta: {
            caption: 'entities.ibizorder.views.tabexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'tabexpview', parameterName: 'tabexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-tab-exp-view/ibizorder-tab-exp-view.vue'),
    },
    {
        path: '/ibizcustoms/:ibizcustom?/customgridview/:customgridview?',
        meta: {
            caption: 'entities.ibizcustom.views.customgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustoms', parameterName: 'ibizcustom' },
                { pathName: 'customgridview', parameterName: 'customgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustom-custom-grid-view/ibizcustom-custom-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr5gridview/:usr5gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr5gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr5gridview', parameterName: 'usr5gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr5-grid-view/ibizbookusr5-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/usr2calendarexpview/:usr2calendarexpview?',
        meta: {
            caption: 'entities.ibizorder.views.usr2calendarexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'usr2calendarexpview', parameterName: 'usr2calendarexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-usr2-calendar-exp-view/ibizorder-usr2-calendar-exp-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2gridview/:usr2gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr2gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2gridview', parameterName: 'usr2gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-grid-view/ibizbookusr2-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/groupbycodelistlistview/:groupbycodelistlistview?',
        meta: {
            caption: 'entities.ibizbook.views.groupbycodelistlistview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'groupbycodelistlistview', parameterName: 'groupbycodelistlistview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookgroup-by-codelist-list-view/ibizbookgroup-by-codelist-list-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr8gridview/:usr8gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr8gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr8gridview', parameterName: 'usr8gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr8-grid-view/ibizbookusr8-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usreditview_actionplugin/:usreditview_actionplugin?',
        meta: {
            caption: 'entities.ibizbook.views.usreditview_actionplugin.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usreditview_actionplugin', parameterName: 'usreditview_actionplugin' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr-edit-view-action-plugin/ibizbookusr-edit-view-action-plugin.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/treeexpview/:treeexpview?',
        meta: {
            caption: 'entities.ibizbook.views.treeexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'treeexpview', parameterName: 'treeexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbooktree-exp-view/ibizbooktree-exp-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/customview_layout/:customview_layout?',
        meta: {
            caption: 'entities.ibizbook.views.customview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'customview_layout', parameterName: 'customview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookcustom-view-layout/ibizbookcustom-view-layout.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr9gridview/:usr9gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr9gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr9gridview', parameterName: 'usr9gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr9-grid-view/ibizbookusr9-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/dashboardview/:dashboardview?',
        meta: {
            caption: 'entities.ibizorder.views.dashboardview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'dashboardview', parameterName: 'dashboardview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-dashboard-view/ibizorder-dashboard-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/dashboardview_layout/:dashboardview_layout?',
        meta: {
            caption: 'entities.ibizbook.views.dashboardview_layout.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'dashboardview_layout', parameterName: 'dashboardview_layout' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookdashboard-view-layout/ibizbookdashboard-view-layout.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr9editview/:usr9editview?',
        meta: {
            caption: 'entities.ibizbook.views.usr9editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr9editview', parameterName: 'usr9editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr9-edit-view/ibizbookusr9-edit-view.vue'),
    },
    {
        path: '/ibizsample0021s/:ibizsample0021?/addstepbeforewfdynaactionview/:addstepbeforewfdynaactionview?',
        meta: {
            caption: 'entities.ibizsample0021.views.addstepbeforewfdynaactionview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0021s', parameterName: 'ibizsample0021' },
                { pathName: 'addstepbeforewfdynaactionview', parameterName: 'addstepbeforewfdynaactionview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0021-addstepbeforewfdyna-action-view/ibizsample0021-addstepbeforewfdyna-action-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf3editview/:sf3editview?',
        meta: {
            caption: 'entities.ibizorder.views.sf3editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf3editview', parameterName: 'sf3editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf3-edit-view/ibizorder-sf3-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr6editview/:usr6editview?',
        meta: {
            caption: 'entities.ibizbook.views.usr6editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr6editview', parameterName: 'usr6editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr6-edit-view/ibizbookusr6-edit-view.vue'),
    },
    {
        path: '/ibizappextendeditors/:ibizappextendeditor?/listview/:listview?',
        meta: {
            caption: 'entities.ibizappextendeditor.views.listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizappextendeditors', parameterName: 'ibizappextendeditor' },
                { pathName: 'listview', parameterName: 'listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizappextendeditorlist-view/ibizappextendeditorlist-view.vue'),
    },
    {
        path: '/apppanelview/:apppanelview?',
        meta: {
            caption: 'app.views.apppanelview.caption',
            info:'',
            parameters: [
                { pathName: 'apppanelview', parameterName: 'apppanelview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ungroup/app-panel-view/app-panel-view.vue'),
    },
    {
        path: '/appwfsteptraceview/:appwfsteptraceview?',
        meta: {
            caption: 'app.views.appwfsteptraceview.caption',
            info:'',
            parameters: [
                { pathName: 'appwfsteptraceview', parameterName: 'appwfsteptraceview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ungroup/app-wfstep-trace-view/app-wfstep-trace-view.vue'),
    },
    {
        path: '/appportalview/:appportalview?',
        meta: {
            caption: 'app.views.appportalview.caption',
            info:'',
            parameters: [
                { pathName: 'appportalview', parameterName: 'appportalview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ungroup/app-portal-view/app-portal-view.vue'),
    },
            {
                path: '/appwfdataredirectview/:appwfdataredirectview?',
                meta: {
                    caption: 'app.views.appwfredirectview.caption',
                    info:'',
                    viewType: 'REDIRECTVIEW',
                    parameters: [
                        
                        { pathName: 'appwfredirectview', parameterName: 'appwfredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/ungroup/app-wfredirect-view/app-wfredirect-view.vue'),
            },
    {
        path: '/apppanelview2/:apppanelview2?',
        meta: {
            caption: 'app.views.apppanelview2.caption',
            info:'',
            parameters: [
                { pathName: 'apppanelview2', parameterName: 'apppanelview2' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ungroup/app-panel-view2/app-panel-view2.vue'),
    },
        ...globalRoutes,
        {
            path: '/login/:login?',
            name: 'login',
            meta: {  
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                router.app.$store.commit('resetRootStateData');
                next();
            },
            component: () => import('@pages/ungroup/app-login-view/app-login-view.vue'),
        },
        {
            path: '/lock',
            name: 'lock',
            meta: {  
                caption: '锁屏',
                viewType: 'lock',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                next();
            },
            component: () => import('@components/app-lock/app-lock.vue'),
        },
        {
            path: '/404',
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            component: () => import('@components/500/500.vue')
        },
        {
            path: '*',
            redirect: 'appindexview2'
        },
    ],
});
// 解决路由跳转路由重复时报错
const originalPush = Router.prototype.push
Router.prototype.push = function push(location: any) {
    let result: any = originalPush.call(this, location);
    return result.catch((err: any) => err);
}
export default router;
