/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'sn',
          prop: 'sn',
          dataType: 'TEXT',
        },
        {
          name: 'ibizsample0014name',
          prop: 'ibizsample0014name',
          dataType: 'TEXT',
        },
        {
          name: 'ibizsample0014id',
          prop: 'ibizsample0014id',
          dataType: 'GUID',
        },
        {
          name: 'updateman',
          prop: 'updateman',
          dataType: 'TEXT',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizsample0014name',
          dataType: 'TEXT',
        },
        {
          name: 'ibizsample0003id',
          prop: 'ibizsample0003id',
          dataType: 'PICKUP',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizsample0014id',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizsample0014id',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'ibizsample0014',
          prop: 'ibizsample0014id',
        },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}