package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZSupplierDTO]
 */
@Data
public class IBIZSupplierDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [DELETEFLAG]
     *
     */
    @JSONField(name = "deleteflag")
    @JsonProperty("deleteflag")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String deleteflag;

    /**
     * 属性 [CREATEBY]
     *
     */
    @JSONField(name = "createby")
    @JsonProperty("createby")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String createby;

    /**
     * 属性 [UPDATEBY]
     *
     */
    @JSONField(name = "updateby")
    @JsonProperty("updateby")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String updateby;

    /**
     * 属性 [UPDATETIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatetime" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatetime")
    private Timestamp updatetime;

    /**
     * 属性 [EMAIL]
     *
     */
    @JSONField(name = "email")
    @JsonProperty("email")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String email;

    /**
     * 属性 [SUPPLIERNAME]
     *
     */
    @JSONField(name = "suppliername")
    @JsonProperty("suppliername")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String suppliername;

    /**
     * 属性 [CREATETIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createtime" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createtime")
    private Timestamp createtime;

    /**
     * 属性 [ADDRESS]
     *
     */
    @JSONField(name = "address")
    @JsonProperty("address")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String address;

    /**
     * 属性 [SUPPLIERID]
     *
     */
    @JSONField(name = "supplierid")
    @JsonProperty("supplierid")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String supplierid;


    /**
     * 设置 [EMAIL]
     */
    public void setEmail(String  email){
        this.email = email ;
        this.modify("email",email);
    }

    /**
     * 设置 [SUPPLIERNAME]
     */
    public void setSuppliername(String  suppliername){
        this.suppliername = suppliername ;
        this.modify("suppliername",suppliername);
    }

    /**
     * 设置 [ADDRESS]
     */
    public void setAddress(String  address){
        this.address = address ;
        this.modify("address",address);
    }


}


